/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.structure.strategy;

import com.tinkerpop.gremlin.AbstractGremlinTest;
import com.tinkerpop.gremlin.FeatureRequirement;
import com.tinkerpop.gremlin.FeatureRequirementSet;
import com.tinkerpop.gremlin.FeatureRequirements;
import com.tinkerpop.gremlin.LoadGraphWith;
import com.tinkerpop.gremlin.process.T;
import com.tinkerpop.gremlin.structure.Direction;
import com.tinkerpop.gremlin.structure.Edge;
import com.tinkerpop.gremlin.structure.Element;
import com.tinkerpop.gremlin.structure.Graph;
import com.tinkerpop.gremlin.structure.Property;
import com.tinkerpop.gremlin.structure.Vertex;
import com.tinkerpop.gremlin.structure.VertexProperty;
import com.tinkerpop.gremlin.structure.strategy.GraphStrategy;
import com.tinkerpop.gremlin.structure.strategy.IdStrategy;
import com.tinkerpop.gremlin.structure.strategy.IdentityStrategy;
import com.tinkerpop.gremlin.structure.strategy.PartitionStrategy;
import com.tinkerpop.gremlin.structure.strategy.ReadOnlyStrategy;
import com.tinkerpop.gremlin.structure.strategy.SequenceStrategy;
import com.tinkerpop.gremlin.structure.strategy.StrategyContext;
import com.tinkerpop.gremlin.structure.strategy.StrategyEdge;
import com.tinkerpop.gremlin.structure.strategy.StrategyElement;
import com.tinkerpop.gremlin.structure.strategy.StrategyGraph;
import com.tinkerpop.gremlin.structure.strategy.StrategyProperty;
import com.tinkerpop.gremlin.structure.strategy.StrategyVariables;
import com.tinkerpop.gremlin.structure.strategy.StrategyVertex;
import com.tinkerpop.gremlin.structure.strategy.StrategyVertexProperty;
import com.tinkerpop.gremlin.structure.strategy.SubgraphStrategy;
import com.tinkerpop.gremlin.structure.util.StringFactory;
import com.tinkerpop.gremlin.util.StreamFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.javatuples.Pair;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Enclosed.class)
public class StrategyGraphTest {

    @RunWith(value=Parameterized.class)
    public static class GraphShouldBeWrappedTest
    extends AbstractGremlinTest {
        @Parameterized.Parameter(value=0)
        public String name;
        @Parameterized.Parameter(value=1)
        public BiFunction<Graph, AbstractGremlinTest, Stream<Graph>> streamGetter;

        @Parameterized.Parameters(name="{0}")
        public static Iterable<Object[]> data() {
            ArrayList<Pair> tests = new ArrayList<Pair>();
            tests.add(Pair.with((Object)"g.V(1).graph()", (g, instance) -> Stream.of(((Vertex)g.V(new Object[]{instance.convertToVertexId("marko")}).next()).graph())));
            tests.add(Pair.with((Object)"g.V(1).iterators().edgeIterator(BOTH).map(Edge::graph)", (g, instance) -> StreamFactory.stream((Iterator)((Vertex)g.V(new Object[]{instance.convertToVertexId("marko")}).next()).iterators().edgeIterator(Direction.BOTH, new String[0])).map(Element::graph)));
            tests.add(Pair.with((Object)"g.V(1).iterators().propertyIterator().map(Edge::graph)", (g, instance) -> StreamFactory.stream((Iterator)((Vertex)g.V(new Object[]{instance.convertToVertexId("marko")}).next()).iterators().propertyIterator(new String[0])).map(VertexProperty::graph)));
            return tests.stream().map(d -> {
                Object[] o = new Object[]{d.getValue0(), d.getValue1()};
                return o;
            }).collect(Collectors.toList());
        }

        @Test
        @LoadGraphWith(value=LoadGraphWith.GraphData.CREW)
        public void shouldWrap() {
            StrategyGraph swg = this.g.strategy(new GraphStrategy[]{IdentityStrategy.instance()});
            AtomicBoolean atLeastOne = new AtomicBoolean(false);
            Assert.assertTrue((boolean)this.streamGetter.apply((Graph)swg, this).allMatch(v -> {
                atLeastOne.set(true);
                return v instanceof StrategyGraph;
            }));
            Assert.assertTrue((boolean)atLeastOne.get());
        }
    }

    @RunWith(value=Parameterized.class)
    public static class VertexShouldBeWrappedTest
    extends AbstractGremlinTest {
        @Parameterized.Parameter(value=0)
        public String name;
        @Parameterized.Parameter(value=1)
        public BiFunction<Graph, AbstractGremlinTest, Stream<Vertex>> streamGetter;

        @Parameterized.Parameters(name="{0}")
        public static Iterable<Object[]> data() {
            ArrayList<Pair> tests = new ArrayList<Pair>();
            tests.add(Pair.with((Object)"g.V()", (g, instance) -> StreamFactory.stream((Iterator)g.V(new Object[0]))));
            tests.add(Pair.with((Object)"g.iterators().vertexIterator()", (g, instance) -> StreamFactory.stream((Iterator)g.iterators().vertexIterator(new Object[0]))));
            tests.add(Pair.with((Object)"g.iterators().vertexIterator(1)", (g, instance) -> StreamFactory.stream((Iterator)g.iterators().vertexIterator(new Object[]{instance.convertToVertexId("marko")}))));
            tests.add(Pair.with((Object)"g.V(1)", (g, instance) -> Stream.of(g.V(new Object[]{instance.convertToVertexId("marko")}).next())));
            tests.add(Pair.with((Object)"g.V(1).outE().inV()", (g, instance) -> StreamFactory.stream((Iterator)g.V(new Object[]{instance.convertToVertexId("marko")}).outE(new String[0]).inV())));
            tests.add(Pair.with((Object)"g.V(4).bothE().bothV()", (g, instance) -> StreamFactory.stream((Iterator)g.V(new Object[]{instance.convertToVertexId("josh")}).bothE(new String[0]).bothV())));
            tests.add(Pair.with((Object)"g.V(4).inE().outV()", (g, instance) -> StreamFactory.stream((Iterator)g.V(new Object[]{instance.convertToVertexId("josh")}).inE(new String[0]).outV())));
            tests.add(Pair.with((Object)"g.V(1).out()", (g, instance) -> StreamFactory.stream((Iterator)g.V(new Object[]{instance.convertToVertexId("marko")}).out(new String[0]))));
            tests.add(Pair.with((Object)"g.V(4).iterators().vertexIterator(Direction.BOTH)", (g, instance) -> StreamFactory.stream((Iterator)((Vertex)g.V(new Object[]{instance.convertToVertexId("josh")}).next()).iterators().vertexIterator(Direction.BOTH, new String[0]))));
            tests.add(Pair.with((Object)"g.V(1).iterators().vertexIterator(Direction.OUT)", (g, instance) -> StreamFactory.stream((Iterator)((Vertex)g.V(new Object[]{instance.convertToVertexId("marko")}).next()).iterators().vertexIterator(Direction.OUT, new String[0]))));
            tests.add(Pair.with((Object)"g.V(4).iterators().vertexIterator(Direction.IN)", (g, instance) -> StreamFactory.stream((Iterator)((Vertex)g.V(new Object[]{instance.convertToVertexId("josh")}).next()).iterators().vertexIterator(Direction.IN, new String[0]))));
            tests.add(Pair.with((Object)"g.V(4).iterators().vertexIterator(Direction.BOTH, \"created\")", (g, instance) -> StreamFactory.stream((Iterator)((Vertex)g.V(new Object[]{instance.convertToVertexId("josh")}).next()).iterators().vertexIterator(Direction.BOTH, new String[]{"created"}))));
            tests.add(Pair.with((Object)"g.E(11).iterators().vertexIterator(Direction.IN)", (g, instance) -> StreamFactory.stream((Iterator)((Edge)g.E(new Object[]{instance.convertToEdgeId("josh", "created", "lop")}).next()).iterators().vertexIterator(Direction.IN))));
            tests.add(Pair.with((Object)"g.E(11).iterators().vertexIterator(Direction.OUT)", (g, instance) -> StreamFactory.stream((Iterator)((Edge)g.E(new Object[]{instance.convertToEdgeId("josh", "created", "lop")}).next()).iterators().vertexIterator(Direction.OUT))));
            tests.add(Pair.with((Object)"g.E(11).iterators().vertexIterator(Direction.BOTH)", (g, instance) -> StreamFactory.stream((Iterator)((Edge)g.E(new Object[]{instance.convertToEdgeId("josh", "created", "lop")}).next()).iterators().vertexIterator(Direction.BOTH))));
            tests.add(Pair.with((Object)"g.V(1).iterators().properties(name).next().element()", (g, instance) -> StreamFactory.stream((Object)((VertexProperty)((Vertex)g.V(new Object[]{instance.convertToVertexId("marko")}).next()).iterators().propertyIterator(new String[]{"name"}).next()).element())));
            tests.add(Pair.with((Object)"g.V(1).outE().otherV()", (g, instance) -> StreamFactory.stream((Iterator)g.V(new Object[]{instance.convertToVertexId("marko")}).outE(new String[0]).otherV())));
            tests.add(Pair.with((Object)"g.V(4).inE().otherV()", (g, instance) -> StreamFactory.stream((Iterator)g.V(new Object[]{instance.convertToVertexId("josh")}).inE(new String[0]).otherV())));
            return tests.stream().map(d -> {
                Object[] o = new Object[]{d.getValue0(), d.getValue1()};
                return o;
            }).collect(Collectors.toList());
        }

        @Test
        @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
        public void shouldWrap() {
            StrategyGraph swg = this.g.strategy(new GraphStrategy[]{IdentityStrategy.instance()});
            AtomicBoolean atLeastOne = new AtomicBoolean(false);
            Assert.assertTrue((boolean)this.streamGetter.apply((Graph)swg, this).allMatch(v -> {
                atLeastOne.set(true);
                return v instanceof StrategyVertex;
            }));
            Assert.assertTrue((boolean)atLeastOne.get());
        }
    }

    @RunWith(value=Parameterized.class)
    public static class EdgeShouldBeWrappedTest
    extends AbstractGremlinTest {
        @Parameterized.Parameter(value=0)
        public String name;
        @Parameterized.Parameter(value=1)
        public BiFunction<Graph, AbstractGremlinTest, Stream<Edge>> streamGetter;

        @Parameterized.Parameters(name="{0}")
        public static Iterable<Object[]> data() {
            ArrayList<Pair> tests = new ArrayList<Pair>();
            tests.add(Pair.with((Object)"g.E()", (g, instance) -> StreamFactory.stream((Iterator)g.E(new Object[0]))));
            tests.add(Pair.with((Object)"g.iterators().edgeIterator()", (g, instance) -> StreamFactory.stream((Iterator)g.iterators().edgeIterator(new Object[0]))));
            tests.add(Pair.with((Object)"g.iterators().edgeIterator(11)", (g, instance) -> StreamFactory.stream((Iterator)g.iterators().edgeIterator(new Object[]{instance.convertToEdgeId("josh", "created", "lop")}))));
            tests.add(Pair.with((Object)"g.E(11)", (g, instance) -> Stream.of(g.E(new Object[]{instance.convertToEdgeId("josh", "created", "lop")}).next())));
            tests.add(Pair.with((Object)"g.V(1).outE()", (g, instance) -> StreamFactory.stream((Iterator)g.V(new Object[]{instance.convertToVertexId("marko")}).outE(new String[0]))));
            tests.add(Pair.with((Object)"g.V(4).bothE()", (g, instance) -> StreamFactory.stream((Iterator)g.V(new Object[]{instance.convertToVertexId("josh")}).bothE(new String[0]))));
            tests.add(Pair.with((Object)"g.V(4).inE()", (g, instance) -> StreamFactory.stream((Iterator)g.V(new Object[]{instance.convertToVertexId("josh")}).inE(new String[0]))));
            tests.add(Pair.with((Object)"g.V(11).property(weight).element()", (g, instance) -> Stream.of((Edge)((Edge)g.E(new Object[]{instance.convertToEdgeId("josh", "created", "lop")}).next()).property("weight").element())));
            tests.add(Pair.with((Object)"g.V(4).next().iterators().edgeIterator(Direction.BOTH)", (g, instance) -> StreamFactory.stream((Iterator)((Vertex)g.V(new Object[]{instance.convertToVertexId("josh")}).next()).iterators().edgeIterator(Direction.BOTH, new String[0]))));
            tests.add(Pair.with((Object)"g.V(1).next().iterators().edgeIterator(Direction.OUT)", (g, instance) -> StreamFactory.stream((Iterator)((Vertex)g.V(new Object[]{instance.convertToVertexId("marko")}).next()).iterators().edgeIterator(Direction.OUT, new String[0]))));
            tests.add(Pair.with((Object)"g.V(4).next().iterators().edgeIterator(Direction.IN)", (g, instance) -> StreamFactory.stream((Iterator)((Vertex)g.V(new Object[]{instance.convertToVertexId("josh")}).next()).iterators().edgeIterator(Direction.IN, new String[0]))));
            return tests.stream().map(d -> {
                Object[] o = new Object[]{d.getValue0(), d.getValue1()};
                return o;
            }).collect(Collectors.toList());
        }

        @Test
        @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
        public void shouldWrap() {
            StrategyGraph swg = this.g.strategy(new GraphStrategy[]{IdentityStrategy.instance()});
            AtomicBoolean atLeastOne = new AtomicBoolean(false);
            Assert.assertTrue((boolean)this.streamGetter.apply((Graph)swg, this).allMatch(e -> {
                atLeastOne.set(true);
                return e instanceof StrategyEdge;
            }));
            Assert.assertTrue((boolean)atLeastOne.get());
        }
    }

    @RunWith(value=Parameterized.class)
    public static class VertexPropertyWithMultiPropertyShouldBeWrappedTest
    extends AbstractGremlinTest {
        @Parameterized.Parameter(value=0)
        public String name;
        @Parameterized.Parameter(value=1)
        public BiFunction<Graph, Vertex, Stream<? extends Property<Object>>> streamGetter;

        @Parameterized.Parameters(name="{0}")
        public static Iterable<Object[]> data() {
            ArrayList<Pair> tests = new ArrayList<Pair>();
            tests.add(Pair.with((Object)"v.property(all)", (g, v) -> Stream.of(v.property("all"))));
            tests.add(Pair.with((Object)"v.property(extra, data)", (g, v) -> Stream.of(v.property("extra", (Object)"data"))));
            tests.add(Pair.with((Object)"v.iterators().properties()", (g, v) -> StreamFactory.stream((Iterator)v.iterators().propertyIterator(new String[0]))));
            tests.add(Pair.with((Object)"v.iterators().properties(any)", (g, v) -> StreamFactory.stream((Iterator)v.iterators().propertyIterator(new String[]{"any"}))));
            tests.add(Pair.with((Object)"v.properties()", (g, v) -> StreamFactory.stream((Iterator)v.properties(new String[0]))));
            tests.add(Pair.with((Object)"v.property(extra,more)", (g, v) -> Stream.of(v.property("extra", (Object)"more"))));
            return tests.stream().map(d -> {
                Object[] o = new Object[]{d.getValue0(), d.getValue1()};
                return o;
            }).collect(Collectors.toList());
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
        @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties")
        public void shouldWrap() {
            StrategyGraph swg = this.g.strategy(new GraphStrategy[]{IdentityStrategy.instance()});
            Vertex v = swg.addVertex(new Object[]{"all", "a", "any", "something", "any", "something-else", "hideme", "hidden", "hideme", "hidden-too"});
            AtomicBoolean atLeastOne = new AtomicBoolean(false);
            Assert.assertTrue((boolean)this.streamGetter.apply(this.g, v).allMatch(p -> {
                atLeastOne.set(true);
                return p instanceof StrategyVertexProperty;
            }));
            Assert.assertTrue((boolean)atLeastOne.get());
        }
    }

    @RunWith(value=Parameterized.class)
    public static class VertexPropertyShouldBeWrappedTest
    extends AbstractGremlinTest {
        @Parameterized.Parameter(value=0)
        public String name;
        @Parameterized.Parameter(value=1)
        public BiFunction<Graph, Vertex, Stream<? extends Property<Object>>> streamGetter;

        @Parameterized.Parameters(name="{0}")
        public static Iterable<Object[]> data() {
            ArrayList<Pair> tests = new ArrayList<Pair>();
            tests.add(Pair.with((Object)"v.property(all)", (g, v) -> Stream.of(v.property("all"))));
            tests.add(Pair.with((Object)"v.property(extra, data)", (g, v) -> Stream.of(v.property("extra", (Object)"data"))));
            tests.add(Pair.with((Object)"v.iterators().properties()", (g, v) -> StreamFactory.stream((Iterator)v.iterators().propertyIterator(new String[0]))));
            tests.add(Pair.with((Object)"v.iterators().properties(any)", (g, v) -> StreamFactory.stream((Iterator)v.iterators().propertyIterator(new String[]{"any"}))));
            tests.add(Pair.with((Object)"v.properties()", (g, v) -> StreamFactory.stream((Iterator)v.properties(new String[0]))));
            tests.add(Pair.with((Object)"v.property(extra,more)", (g, v) -> Stream.of(v.property("extra", (Object)"more"))));
            return tests.stream().map(d -> {
                Object[] o = new Object[]{d.getValue0(), d.getValue1()};
                return o;
            }).collect(Collectors.toList());
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
        public void shouldWrap() {
            StrategyGraph swg = this.g.strategy(new GraphStrategy[]{IdentityStrategy.instance()});
            Vertex v = swg.addVertex(new Object[]{"all", "a", "any", "something", "hideme", "hidden"});
            AtomicBoolean atLeastOne = new AtomicBoolean(false);
            Assert.assertTrue((boolean)this.streamGetter.apply(this.g, v).allMatch(p -> {
                atLeastOne.set(true);
                return p instanceof StrategyVertexProperty;
            }));
            Assert.assertTrue((boolean)atLeastOne.get());
        }
    }

    @RunWith(value=Parameterized.class)
    public static class VertexPropertyPropertyShouldBeWrappedTests
    extends AbstractGremlinTest {
        @Parameterized.Parameter(value=0)
        public String name;
        @Parameterized.Parameter(value=1)
        public BiFunction<Graph, VertexProperty, Stream<? extends Property<Object>>> streamGetter;

        @Parameterized.Parameters(name="{0}")
        public static Iterable<Object[]> data() {
            ArrayList<Pair> tests = new ArrayList<Pair>();
            tests.add(Pair.with((Object)"vp.property(food)", (g, vp) -> Stream.of(vp.property("food"))));
            tests.add(Pair.with((Object)"vp.property(moreFood,sandwhich)", (g, vp) -> Stream.of(vp.property("moreFood", (Object)"sandwhich"))));
            tests.add(Pair.with((Object)"vp.iterators().properties()", (g, vp) -> StreamFactory.stream((Iterator)vp.iterators().propertyIterator(new String[0]))));
            tests.add(Pair.with((Object)"vp.iterators().properties(food)", (g, vp) -> StreamFactory.stream((Iterator)vp.iterators().propertyIterator(new String[]{"food"}))));
            tests.add(Pair.with((Object)"vp.propertyMap().next().values()", (g, vp) -> StreamFactory.stream(((Map)vp.propertyMap(new String[0]).next()).values())));
            return tests.stream().map(d -> {
                Object[] o = new Object[]{d.getValue0(), d.getValue1()};
                return o;
            }).collect(Collectors.toList());
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties")
        public void shouldWrap() {
            StrategyGraph swg = this.g.strategy(new GraphStrategy[]{IdentityStrategy.instance()});
            Vertex v = swg.addVertex(new Object[0]);
            VertexProperty vp = v.property("property", (Object)"on-property", new Object[]{"food", "taco", "more", "properties"});
            AtomicBoolean atLeastOne = new AtomicBoolean(false);
            Assert.assertTrue((boolean)this.streamGetter.apply((Graph)swg, vp).allMatch(p -> {
                atLeastOne.set(true);
                return p instanceof StrategyProperty;
            }));
            Assert.assertTrue((boolean)atLeastOne.get());
        }
    }

    @RunWith(value=Parameterized.class)
    public static class EdgePropertyShouldBeWrappedTests
    extends AbstractGremlinTest {
        @Parameterized.Parameter(value=0)
        public String name;
        @Parameterized.Parameter(value=1)
        public BiFunction<Graph, Edge, Stream<? extends Property<Object>>> streamGetter;

        @Parameterized.Parameters(name="{0}")
        public static Iterable<Object[]> data() {
            ArrayList<Pair> tests = new ArrayList<Pair>();
            tests.add(Pair.with((Object)"e.property(all)", (g, e) -> Stream.of(e.property("all"))));
            tests.add(Pair.with((Object)"e.iterators().properties()", (g, e) -> StreamFactory.stream((Iterator)e.iterators().propertyIterator(new String[0]))));
            tests.add(Pair.with((Object)"e.iterators().properties(any)", (g, e) -> StreamFactory.stream((Iterator)e.iterators().propertyIterator(new String[]{"any"}))));
            tests.add(Pair.with((Object)"e.properties()", (g, e) -> StreamFactory.stream((Iterator)e.properties(new String[0]))));
            tests.add(Pair.with((Object)"e.property(extra,more)", (g, e) -> Stream.of(e.property("extra", (Object)"more"))));
            return tests.stream().map(d -> {
                Object[] o = new Object[]{d.getValue0(), d.getValue1()};
                return o;
            }).collect(Collectors.toList());
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
        public void shouldWrap() {
            StrategyGraph swg = this.g.strategy(new GraphStrategy[]{IdentityStrategy.instance()});
            Vertex v = swg.addVertex(new Object[0]);
            Edge e = v.addEdge("to", v, new Object[]{"all", "a", "any", "something", "hideme", "hidden"});
            AtomicBoolean atLeastOne = new AtomicBoolean(false);
            Assert.assertTrue((boolean)this.streamGetter.apply((Graph)swg, e).allMatch(p -> {
                atLeastOne.set(true);
                return p instanceof StrategyProperty;
            }));
            Assert.assertTrue((boolean)atLeastOne.get());
        }
    }

    public static class BlockBaseFunctionTest
    extends AbstractGremlinTest {
        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
        public void shouldNotCallBaseFunctionThusNotRemovingTheVertex() throws Exception {
            StrategyGraph swg = this.g.strategy(new GraphStrategy[]{new GraphStrategy(){

                public UnaryOperator<Supplier<Void>> getRemoveVertexStrategy(StrategyContext<StrategyVertex> ctx, GraphStrategy composingStrategy) {
                    return t -> () -> {
                        Vertex v = ((StrategyVertex)ctx.getCurrent()).getBaseVertex();
                        v.bothE(new String[0]).remove();
                        v.properties(new String[0]).forEachRemaining(Property::remove);
                        v.property("deleted", (Object)true);
                        return null;
                    };
                }
            }});
            Vertex toRemove = this.g.addVertex(new Object[]{"name", "pieter"});
            toRemove.addEdge("likes", this.g.addVertex(new Object[]{"feature", "Strategy"}), new Object[0]);
            Assert.assertEquals((long)1L, (long)((Long)toRemove.properties(new String[0]).count().next()).intValue());
            Assert.assertEquals((Object)new Long(1L), (Object)toRemove.bothE(new String[0]).count().next());
            Assert.assertFalse((boolean)toRemove.property("deleted").isPresent());
            swg.V(new Object[]{toRemove.id()}).remove();
            Vertex removed = (Vertex)this.g.V(new Object[]{toRemove.id()}).next();
            Assert.assertNotNull((Object)removed);
            Assert.assertEquals((long)1L, (long)((Long)removed.properties(new String[0]).count().next()).intValue());
            Assert.assertEquals((Object)new Long(0L), (Object)removed.bothE(new String[0]).count().next());
            Assert.assertTrue((boolean)removed.property("deleted").isPresent());
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
        public void shouldNotCallBaseFunctionThusNotRemovingTheEdge() throws Exception {
            StrategyGraph swg = this.g.strategy(new GraphStrategy[]{new GraphStrategy(){

                public UnaryOperator<Supplier<Void>> getRemoveEdgeStrategy(StrategyContext<StrategyEdge> ctx, GraphStrategy composingStrategy) {
                    return t -> () -> {
                        Edge e = ((StrategyEdge)ctx.getCurrent()).getBaseEdge();
                        e.properties(new String[0]).forEachRemaining(Property::remove);
                        e.property("deleted", (Object)true);
                        return null;
                    };
                }
            }});
            Vertex v = this.g.addVertex(new Object[]{"name", "pieter"});
            Edge e = v.addEdge("likes", this.g.addVertex(new Object[]{"feature", "Strategy"}), new Object[]{"this", "something"});
            Assert.assertEquals((long)1L, (long)((Long)e.properties(new String[0]).count().next()).intValue());
            Assert.assertFalse((boolean)e.property("deleted").isPresent());
            swg.E(new Object[]{e.id()}).remove();
            Edge removed = (Edge)this.g.E(new Object[]{e.id()}).next();
            Assert.assertNotNull((Object)removed);
            Assert.assertEquals((long)1L, (long)((Long)removed.properties(new String[0]).count().next()).intValue());
            Assert.assertTrue((boolean)removed.property("deleted").isPresent());
        }

        @Test
        public void shouldAdHocTheCloseStrategy() throws Exception {
            final AtomicInteger counter = new AtomicInteger(0);
            StrategyGraph swg = this.g.strategy(new GraphStrategy[]{new GraphStrategy(){

                public UnaryOperator<Supplier<Void>> getGraphCloseStrategy(StrategyContext<StrategyGraph> ctx, GraphStrategy composingStrategy) {
                    return t -> () -> {
                        counter.incrementAndGet();
                        return null;
                    };
                }
            }});
            swg.close();
            swg.close();
            swg.close();
            Assert.assertEquals((long)3L, (long)counter.get());
        }
    }

    @RunWith(value=Parameterized.class)
    public static class ToStringConsistencyTest
    extends AbstractGremlinTest {
        @Parameterized.Parameter(value=0)
        public GraphStrategy strategy;

        @Parameterized.Parameters(name="{0}")
        public static Iterable<Object[]> data() {
            return new ArrayList<Object[]>(){
                {
                    this.add(new Object[]{IdentityStrategy.instance()});
                    this.add(new Object[]{IdStrategy.build((String)"key").create()});
                    this.add(new Object[]{PartitionStrategy.build().partitionKey("partition").startPartition("A").create()});
                    this.add(new Object[]{ReadOnlyStrategy.instance()});
                    this.add(new Object[]{SequenceStrategy.build().sequence(new GraphStrategy[]{ReadOnlyStrategy.instance(), PartitionStrategy.build().partitionKey("partition").startPartition("A").create()}).create()});
                    this.add(new Object[]{SubgraphStrategy.build().create()});
                }
            };
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        public void shouldReturnWrappedVertexToString() {
            StrategyGraph swg = new StrategyGraph(this.g);
            StrategyVertex v1 = (StrategyVertex)swg.addVertex(new Object[]{T.label, "Person"});
            Assert.assertEquals((Object)StringFactory.graphStrategyElementString((StrategyElement)v1), (Object)v1.toString());
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
        public void shouldReturnWrappedEdgeToString() {
            StrategyGraph swg = new StrategyGraph(this.g);
            Vertex v1 = swg.addVertex(new Object[]{T.label, "Person"});
            Vertex v2 = swg.addVertex(new Object[]{T.label, "Person"});
            StrategyEdge e1 = (StrategyEdge)v1.addEdge("friend", v2, new Object[0]);
            Assert.assertEquals((Object)StringFactory.graphStrategyElementString((StrategyElement)e1), (Object)e1.toString());
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        public void shouldReturnWrappedVertexPropertyToString() {
            StrategyGraph swg = new StrategyGraph(this.g);
            Vertex v1 = swg.addVertex(new Object[]{T.label, "Person", "age", "one"});
            StrategyVertexProperty age = (StrategyVertexProperty)v1.property("age");
            Assert.assertEquals((Object)StringFactory.graphStrategyElementString((StrategyElement)age), (Object)age.toString());
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
        public void shouldReturnWrappedPropertyToString() {
            StrategyGraph swg = new StrategyGraph(this.g);
            Vertex v1 = swg.addVertex(new Object[]{T.label, "Person"});
            Vertex v2 = swg.addVertex(new Object[]{T.label, "Person"});
            Edge e1 = v1.addEdge("friend", v2, new Object[]{"weight", "fifty"});
            StrategyProperty weight = (StrategyProperty)e1.property("weight");
            Assert.assertEquals((Object)StringFactory.graphStrategyPropertyString((StrategyProperty)weight), (Object)weight.toString());
        }

        @Test
        public void shouldReturnWrappedGraphToString() {
            StrategyGraph swg = new StrategyGraph(this.g);
            GraphStrategy strategy = swg.getStrategy();
            Assert.assertNotEquals((Object)this.g.toString(), (Object)swg.toString());
            Assert.assertEquals((Object)StringFactory.graphStrategyString((GraphStrategy)strategy, (Graph)this.g), (Object)swg.toString());
        }

        @Test
        @FeatureRequirement(featureClass=Graph.Features.VariableFeatures.class, feature="Variables")
        public void shouldReturnWrappedVariablesToString() {
            StrategyGraph swg = new StrategyGraph(this.g);
            StrategyVariables variables = (StrategyVariables)swg.variables();
            Assert.assertEquals((Object)StringFactory.graphStrategyVariables((StrategyVariables)variables), (Object)variables.toString());
        }
    }

    public static class CoreTest
    extends AbstractGremlinTest {
        @Test(expected=IllegalArgumentException.class)
        public void shouldNotAllowAStrategyWrappedGraphToBeReWrapped() {
            StrategyGraph swg = new StrategyGraph(this.g);
            new StrategyGraph((Graph)swg);
        }

        @Test(expected=IllegalArgumentException.class)
        public void shouldNotAllowAStrategyWrappedGraphToBeReWrappedViaStrategy() {
            StrategyGraph swg = new StrategyGraph(this.g);
            swg.strategy(new GraphStrategy[]{IdentityStrategy.instance()});
        }

        @Test
        @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")
        public void shouldHaveGraphWrappedFromVertex() {
            StrategyGraph swg = new StrategyGraph(this.g);
            Assert.assertTrue((boolean)(swg.addVertex(new Object[0]).graph() instanceof StrategyGraph));
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
        public void shouldHaveGraphWrappedFromEdge() {
            StrategyGraph swg = new StrategyGraph(this.g);
            Vertex v = swg.addVertex(new Object[0]);
            Assert.assertTrue((boolean)(v.addEdge("self", v, new Object[0]).graph() instanceof StrategyGraph));
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="AddProperty"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="Properties")})
        public void shouldHaveGraphWrappedFromVertexProperty() {
            StrategyGraph swg = new StrategyGraph(this.g);
            Assert.assertTrue((boolean)(swg.addVertex(new Object[0]).property("name", (Object)"stephen").graph() instanceof StrategyGraph));
        }
    }
}

