/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.structure.util.detached;

import com.tinkerpop.gremlin.AbstractGremlinTest;
import com.tinkerpop.gremlin.FeatureRequirement;
import com.tinkerpop.gremlin.FeatureRequirementSet;
import com.tinkerpop.gremlin.LoadGraphWith;
import com.tinkerpop.gremlin.structure.Direction;
import com.tinkerpop.gremlin.structure.Edge;
import com.tinkerpop.gremlin.structure.Graph;
import com.tinkerpop.gremlin.structure.Property;
import com.tinkerpop.gremlin.structure.Vertex;
import com.tinkerpop.gremlin.structure.util.detached.DetachedEdge;
import com.tinkerpop.gremlin.structure.util.detached.DetachedFactory;
import com.tinkerpop.gremlin.structure.util.detached.DetachedVertex;
import com.tinkerpop.gremlin.util.StreamFactory;
import java.util.HashMap;
import java.util.Iterator;
import org.javatuples.Pair;
import org.junit.Assert;
import org.junit.Test;

public class DetachedEdgeTest
extends AbstractGremlinTest {
    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldNotConstructNewWithSomethingAlreadyDetached() {
        Vertex v = this.g.addVertex(new Object[0]);
        Edge e = v.addEdge("test", v, new Object[0]);
        DetachedEdge de = DetachedFactory.detach((Edge)e, (boolean)false);
        Assert.assertSame((Object)de, (Object)DetachedFactory.detach((Edge)de, (boolean)false));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")
    public void shouldConstructDetachedEdge() {
        ((Edge)this.g.E(new Object[]{this.convertToEdgeId("marko", "knows", "vadas")}).next()).property("year", (Object)2002);
        DetachedEdge detachedEdge = DetachedFactory.detach((Edge)((Edge)this.g.E(new Object[]{this.convertToEdgeId("marko", "knows", "vadas")}).next()), (boolean)true);
        Assert.assertEquals((Object)this.convertToEdgeId("marko", "knows", "vadas"), (Object)detachedEdge.id());
        Assert.assertEquals((Object)"knows", (Object)detachedEdge.label());
        Assert.assertEquals(DetachedVertex.class, ((Vertex)detachedEdge.iterators().vertexIterator(Direction.OUT).next()).getClass());
        Assert.assertEquals((Object)this.convertToVertexId("marko"), (Object)((Vertex)detachedEdge.iterators().vertexIterator(Direction.OUT).next()).id());
        Assert.assertEquals((Object)"person", (Object)((Vertex)detachedEdge.iterators().vertexIterator(Direction.IN).next()).label());
        Assert.assertEquals(DetachedVertex.class, ((Vertex)detachedEdge.iterators().vertexIterator(Direction.IN).next()).getClass());
        Assert.assertEquals((Object)this.convertToVertexId("vadas"), (Object)((Vertex)detachedEdge.iterators().vertexIterator(Direction.IN).next()).id());
        Assert.assertEquals((Object)"person", (Object)((Vertex)detachedEdge.iterators().vertexIterator(Direction.IN).next()).label());
        Assert.assertEquals((long)2L, (long)StreamFactory.stream((Iterator)detachedEdge.iterators().propertyIterator(new String[0])).count());
        Assert.assertEquals((long)1L, (long)StreamFactory.stream((Iterator)detachedEdge.iterators().propertyIterator(new String[]{"year"})).count());
        Assert.assertEquals((Object)0.5, (Object)((Property)detachedEdge.iterators().propertyIterator(new String[]{"weight"}).next()).value());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")
    public void shouldConstructDetachedEdgeAsReference() {
        ((Edge)this.g.E(new Object[]{this.convertToEdgeId("marko", "knows", "vadas")}).next()).property("year", (Object)2002);
        DetachedEdge detachedEdge = DetachedFactory.detach((Edge)((Edge)this.g.E(new Object[]{this.convertToEdgeId("marko", "knows", "vadas")}).next()), (boolean)false);
        Assert.assertEquals((Object)this.convertToEdgeId("marko", "knows", "vadas"), (Object)detachedEdge.id());
        Assert.assertEquals((Object)"knows", (Object)detachedEdge.label());
        Assert.assertEquals(DetachedVertex.class, ((Vertex)detachedEdge.iterators().vertexIterator(Direction.OUT).next()).getClass());
        Assert.assertEquals((Object)this.convertToVertexId("marko"), (Object)((Vertex)detachedEdge.iterators().vertexIterator(Direction.OUT).next()).id());
        Assert.assertEquals((Object)"person", (Object)((Vertex)detachedEdge.iterators().vertexIterator(Direction.IN).next()).label());
        Assert.assertEquals(DetachedVertex.class, ((Vertex)detachedEdge.iterators().vertexIterator(Direction.IN).next()).getClass());
        Assert.assertEquals((Object)this.convertToVertexId("vadas"), (Object)((Vertex)detachedEdge.iterators().vertexIterator(Direction.IN).next()).id());
        Assert.assertEquals((Object)"person", (Object)((Vertex)detachedEdge.iterators().vertexIterator(Direction.IN).next()).label());
        Assert.assertEquals((long)0L, (long)StreamFactory.stream((Iterator)detachedEdge.iterators().propertyIterator(new String[0])).count());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldEvaluateToEqual() {
        Assert.assertTrue((boolean)DetachedFactory.detach((Edge)((Edge)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next()), (boolean)true).equals((Object)DetachedFactory.detach((Edge)((Edge)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next()), (boolean)true)));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldHaveSameHashCode() {
        Assert.assertEquals((long)DetachedFactory.detach((Edge)((Edge)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next()), (boolean)true).hashCode(), (long)DetachedFactory.detach((Edge)((Edge)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next()), (boolean)true).hashCode());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldAttachToGraph() {
        Edge toDetach = (Edge)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next();
        DetachedEdge detachedEdge = DetachedFactory.detach((Edge)toDetach, (boolean)true);
        Edge attached = detachedEdge.attach(this.g);
        Assert.assertEquals((Object)toDetach, (Object)attached);
        Assert.assertFalse((boolean)(attached instanceof DetachedEdge));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldAttachToVertex() {
        Edge toDetach = (Edge)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next();
        Vertex outV = (Vertex)toDetach.iterators().vertexIterator(Direction.OUT).next();
        DetachedEdge detachedEdge = DetachedFactory.detach((Edge)toDetach, (boolean)true);
        Edge attached = detachedEdge.attach(outV);
        Assert.assertEquals((Object)toDetach, (Object)attached);
        Assert.assertFalse((boolean)(attached instanceof DetachedEdge));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")
    public void shouldNotEvaluateToEqualDifferentId() {
        Object joshCreatedLopEdgeId = this.convertToEdgeId("josh", "created", "lop");
        Vertex vOut = (Vertex)this.g.V(new Object[]{this.convertToVertexId("josh")}).next();
        Vertex vIn = (Vertex)this.g.V(new Object[]{this.convertToVertexId("lop")}).next();
        Edge e = vOut.addEdge("created", vIn, new Object[]{"weight", 0.4});
        Assert.assertFalse((boolean)DetachedFactory.detach((Edge)((Edge)this.g.E(new Object[]{joshCreatedLopEdgeId}).next()), (boolean)true).equals((Object)DetachedFactory.detach((Edge)e, (boolean)true)));
    }

    @Test
    public void shouldConstructDetachedEdgeFromParts() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("x", "a");
        properties.put("y", "b");
        DetachedEdge de = new DetachedEdge((Object)10, "bought", properties, Pair.with((Object)1, (Object)"person"), Pair.with((Object)2, (Object)"product"));
        Assert.assertEquals((Object)10, (Object)de.id());
        Assert.assertEquals((Object)"bought", (Object)de.label());
        Assert.assertEquals((Object)"person", (Object)((Vertex)de.iterators().vertexIterator(Direction.OUT).next()).label());
        Assert.assertEquals((Object)1, (Object)((Vertex)de.iterators().vertexIterator(Direction.OUT).next()).id());
        Assert.assertEquals((Object)"product", (Object)((Vertex)de.iterators().vertexIterator(Direction.IN).next()).label());
        Assert.assertEquals((Object)2, (Object)((Vertex)de.iterators().vertexIterator(Direction.IN).next()).id());
        Assert.assertEquals((long)1L, (long)StreamFactory.stream((Object)de.iterators()).count());
        Assert.assertEquals((Object)"a", (Object)((Property)de.iterators().propertyIterator(new String[]{"x"}).next()).value());
        Assert.assertEquals((long)1L, (long)StreamFactory.stream((Iterator)de.iterators().propertyIterator(new String[]{"x"})).count());
        Assert.assertEquals((Object)"a", (Object)de.property("x").value());
        Assert.assertEquals((Object)"x", (Object)de.property("x").key());
        Assert.assertEquals((Object)"b", (Object)de.property("y").value());
        Assert.assertEquals((Object)"y", (Object)de.property("y").key());
    }

    @Test(expected=UnsupportedOperationException.class)
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldNotAllowSetProperty() {
        Vertex v = this.g.addVertex(new Object[0]);
        Edge e = v.addEdge("test", v, new Object[0]);
        DetachedEdge detachedEdge = DetachedFactory.detach((Edge)e, (boolean)false);
        detachedEdge.property("test", (Object)"test");
    }

    @Test(expected=UnsupportedOperationException.class)
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldNotAllowRemove() {
        Vertex v = this.g.addVertex(new Object[0]);
        Edge e = v.addEdge("test", v, new Object[0]);
        DetachedEdge detachedEdge = DetachedFactory.detach((Edge)e, (boolean)false);
        detachedEdge.remove();
    }
}

