/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.structure.util.detached;

import com.tinkerpop.gremlin.AbstractGremlinTest;
import com.tinkerpop.gremlin.FeatureRequirement;
import com.tinkerpop.gremlin.FeatureRequirementSet;
import com.tinkerpop.gremlin.LoadGraphWith;
import com.tinkerpop.gremlin.structure.Direction;
import com.tinkerpop.gremlin.structure.Edge;
import com.tinkerpop.gremlin.structure.Graph;
import com.tinkerpop.gremlin.structure.Property;
import com.tinkerpop.gremlin.structure.Vertex;
import com.tinkerpop.gremlin.structure.util.detached.DetachedEdge;
import com.tinkerpop.gremlin.structure.util.detached.DetachedFactory;
import com.tinkerpop.gremlin.structure.util.detached.DetachedProperty;
import org.junit.Assert;
import org.junit.Test;

public class DetachedPropertyTest
extends AbstractGremlinTest {
    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldNotConstructNewWithSomethingAlreadyDetached() {
        Vertex v = this.g.addVertex(new Object[0]);
        Edge e = v.addEdge("test", v, new Object[]{"xxx", "yyy"});
        DetachedProperty dp = DetachedFactory.detach((Property)e.property("xxx"));
        Assert.assertSame((Object)dp, (Object)DetachedFactory.detach((Property)dp));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldConstructDetachedPropertyWithPropertyFromEdge() {
        DetachedProperty p = DetachedFactory.detach((Property)((Edge)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next()).property("weight"));
        Assert.assertEquals((Object)"weight", (Object)p.key());
        Assert.assertEquals((double)0.4, (double)((Double)p.value()), (double)1.0E-6);
        Assert.assertEquals(DetachedEdge.class, p.element().getClass());
    }

    @Test(expected=UnsupportedOperationException.class)
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldNotSupportRemove() {
        DetachedFactory.detach((Property)((Edge)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next()).property("weight")).remove();
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldBeEqualProperties() {
        Assert.assertTrue((boolean)DetachedFactory.detach((Property)((Edge)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next()).property("weight")).equals((Object)DetachedFactory.detach((Property)((Edge)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next()).property("weight"))));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldAttachToGraph() {
        Edge e = (Edge)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next();
        Property toDetach = (Property)e.iterators().propertyIterator(new String[]{"weight"}).next();
        DetachedProperty detachedProperty = DetachedFactory.detach((Property)toDetach);
        Property attached = detachedProperty.attach(this.g);
        Assert.assertEquals((Object)toDetach, (Object)attached);
        Assert.assertFalse((boolean)(attached instanceof DetachedProperty));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldAttachToVertex() {
        Edge e = (Edge)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next();
        Property toDetach = (Property)e.iterators().propertyIterator(new String[]{"weight"}).next();
        DetachedProperty detachedProperty = DetachedFactory.detach((Property)toDetach);
        Property attached = detachedProperty.attach((Vertex)e.iterators().vertexIterator(Direction.OUT).next());
        Assert.assertEquals((Object)toDetach, (Object)attached);
        Assert.assertFalse((boolean)(attached instanceof DetachedProperty));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldNotBeEqualPropertiesAsThereIsDifferentId() {
        Assert.assertFalse((boolean)DetachedFactory.detach((Property)((Edge)this.g.E(new Object[]{this.convertToEdgeId("marko", "created", "lop")}).next()).property("weight")).equals((Object)DetachedFactory.detach((Property)((Edge)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next()).property("weight"))));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")
    public void shouldNotBeEqualPropertiesAsThereIsDifferentKey() {
        Object joshCreatedLopEdgeId = this.convertToEdgeId("josh", "created", "lop");
        Edge e = ((Vertex)this.g.V(new Object[]{this.convertToVertexId("josh")}).next()).addEdge("created", (Vertex)this.g.V(new Object[]{this.convertToVertexId("lop")}).next(), new Object[]{"weight", 0.4});
        Assert.assertFalse((boolean)DetachedFactory.detach((Property)e.property("weight")).equals((Object)DetachedFactory.detach((Property)((Edge)this.g.E(new Object[]{joshCreatedLopEdgeId}).next()).property("weight"))));
    }
}

