/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.structure.util.detached;

import com.tinkerpop.gremlin.AbstractGremlinTest;
import com.tinkerpop.gremlin.FeatureRequirementSet;
import com.tinkerpop.gremlin.LoadGraphWith;
import com.tinkerpop.gremlin.structure.Vertex;
import com.tinkerpop.gremlin.structure.VertexProperty;
import com.tinkerpop.gremlin.structure.util.detached.DetachedFactory;
import com.tinkerpop.gremlin.structure.util.detached.DetachedVertex;
import com.tinkerpop.gremlin.structure.util.detached.DetachedVertexProperty;
import com.tinkerpop.gremlin.util.StreamFactory;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;

public class DetachedVertexPropertyTest
extends AbstractGremlinTest {
    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldNotConstructNewWithSomethingAlreadyDetached() {
        Vertex v = this.g.addVertex(new Object[0]);
        VertexProperty vp = v.property("test", (Object)"this");
        DetachedVertexProperty dvp = DetachedFactory.detach((VertexProperty)vp, (boolean)true);
        Assert.assertSame((Object)dvp, (Object)DetachedFactory.detach((VertexProperty)dvp, (boolean)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldConstructDetachedPropertyWithPropertyFromVertex() {
        Vertex v = this.g.addVertex(new Object[0]);
        VertexProperty vp = v.property("test", (Object)"this");
        DetachedVertexProperty mp = DetachedFactory.detach((VertexProperty)vp, (boolean)true);
        Assert.assertEquals((Object)"test", (Object)mp.key());
        Assert.assertEquals((Object)"this", (Object)mp.value());
        Assert.assertEquals(DetachedVertex.class, mp.element().getClass());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldConstructDetachedPropertyWithHiddenFromVertex() {
        Vertex v = this.g.addVertex(new Object[0]);
        VertexProperty vp = v.property("test", (Object)"this");
        DetachedVertexProperty mp = DetachedFactory.detach((VertexProperty)vp, (boolean)true);
        Assert.assertEquals((Object)"test", (Object)mp.key());
        Assert.assertEquals((Object)"this", (Object)mp.value());
        Assert.assertEquals(DetachedVertex.class, mp.element().getClass());
    }

    @Test(expected=UnsupportedOperationException.class)
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldNotSupportRemove() {
        Vertex v = this.g.addVertex(new Object[0]);
        VertexProperty vp = v.property("test", (Object)"this");
        DetachedFactory.detach((VertexProperty)vp, (boolean)true).remove();
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldBeEqualsPropertiesAsIdIsTheSame() {
        Vertex v = this.g.addVertex(new Object[0]);
        VertexProperty vp = v.property("test", (Object)"this");
        DetachedVertexProperty mp1 = DetachedFactory.detach((VertexProperty)vp, (boolean)true);
        DetachedVertexProperty mp2 = DetachedFactory.detach((VertexProperty)vp, (boolean)true);
        Assert.assertTrue((boolean)mp1.equals((Object)mp2));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldNotBeEqualsPropertiesAsIdIsDifferent() {
        Vertex v = this.g.addVertex(new Object[0]);
        VertexProperty vp1 = v.property("test", (Object)"this");
        DetachedVertexProperty mp1 = DetachedFactory.detach((VertexProperty)vp1, (boolean)true);
        VertexProperty vp2 = v.property("testing", (Object)"this");
        DetachedVertexProperty mp2 = DetachedFactory.detach((VertexProperty)vp2, (boolean)true);
        Assert.assertFalse((boolean)mp1.equals((Object)mp2));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CREW)
    public void shouldDetachMultiPropertiesAndMetaProperties() {
        Vertex v1 = this.convertToVertex(this.g, "marko");
        v1.iterators().propertyIterator(new String[]{"location"}).forEachRemaining(vp -> {
            DetachedVertexProperty detached = DetachedFactory.detach((VertexProperty)vp, (boolean)true);
            if (detached.value().equals("san diego")) {
                Assert.assertEquals((long)1997L, (long)((Integer)detached.value("startTime")).intValue());
                Assert.assertEquals((long)2001L, (long)((Integer)detached.value("endTime")).intValue());
                Assert.assertEquals((long)2L, (long)((int)StreamFactory.stream((Iterator)detached.iterators().propertyIterator(new String[0])).count()));
            } else if (vp.value().equals("santa cruz")) {
                Assert.assertEquals((long)2001L, (long)((Integer)detached.value("startTime")).intValue());
                Assert.assertEquals((long)2004L, (long)((Integer)detached.value("endTime")).intValue());
                Assert.assertEquals((long)2L, (long)((int)StreamFactory.stream((Iterator)detached.iterators().propertyIterator(new String[0])).count()));
            } else if (detached.value().equals("brussels")) {
                Assert.assertEquals((long)2004L, (long)((Integer)vp.value("startTime")).intValue());
                Assert.assertEquals((long)2005L, (long)((Integer)vp.value("endTime")).intValue());
                Assert.assertEquals((long)2L, (long)((int)StreamFactory.stream((Iterator)detached.iterators().propertyIterator(new String[0])).count()));
            } else if (detached.value().equals("santa fe")) {
                Assert.assertEquals((long)2005L, (long)((Integer)detached.value("startTime")).intValue());
                Assert.assertEquals((long)1L, (long)((int)StreamFactory.stream((Iterator)detached.iterators().propertyIterator(new String[0])).count()));
            } else {
                Assert.fail((String)"Found a value that should be there");
            }
        });
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldAttachToGraph() {
        Vertex v = this.g.addVertex(new Object[0]);
        VertexProperty toDetach = v.property("test", (Object)"this");
        DetachedVertexProperty detached = DetachedFactory.detach((VertexProperty)toDetach, (boolean)true);
        VertexProperty attached = detached.attach(this.g);
        Assert.assertEquals((Object)toDetach, (Object)attached);
        Assert.assertFalse((boolean)(attached instanceof DetachedVertexProperty));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldAttachToVertex() {
        Vertex v = this.g.addVertex(new Object[0]);
        VertexProperty toDetach = v.property("test", (Object)"this");
        DetachedVertexProperty detached = DetachedFactory.detach((VertexProperty)toDetach, (boolean)true);
        VertexProperty attached = detached.attach(v);
        Assert.assertEquals((Object)toDetach, (Object)attached);
        Assert.assertEquals(toDetach.getClass(), attached.getClass());
        Assert.assertFalse((boolean)(attached instanceof DetachedVertexProperty));
    }
}

