/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.groovy.jsr223;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.gremlin.Imports;
import com.tinkerpop.gremlin.groovy.jsr223.ImportCustomizerProvider;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.groovy.control.customizers.ImportCustomizer;

public abstract class AbstractImportCustomizerProvider
implements ImportCustomizerProvider {
    protected static final String DOT_STAR = ".*";
    protected static final String EMPTY_STRING = "";
    protected static final String PERIOD = ".";
    protected final Set<String> extraImports = new HashSet<String>();
    protected final Set<String> extraStaticImports = new HashSet<String>();

    @Override
    public ImportCustomizer getImportCustomizer() {
        ImportCustomizer ic = new ImportCustomizer();
        for (String imp : Imports.getImports()) {
            ic.addStarImports(new String[]{imp.replace(DOT_STAR, EMPTY_STRING)});
        }
        ic.addImports(new String[]{"com.tinkerpop.gremlin.Tokens.T"});
        ic.addStarImports(new String[]{"com.tinkerpop.gremlin.groovy"});
        ic.addStaticImport(Direction.class.getName(), Direction.OUT.toString());
        ic.addStaticImport(Direction.class.getName(), Direction.IN.toString());
        ic.addStaticImport(Direction.class.getName(), Direction.BOTH.toString());
        ic.addStaticImport(TransactionalGraph.Conclusion.class.getName(), TransactionalGraph.Conclusion.SUCCESS.toString());
        ic.addStaticImport(TransactionalGraph.Conclusion.class.getName(), TransactionalGraph.Conclusion.FAILURE.toString());
        this.importExtras(ic);
        this.importExtraStatics(ic);
        return ic;
    }

    private void importExtraStatics(ImportCustomizer ic) {
        for (String extraStaticImport : this.extraStaticImports) {
            if (extraStaticImport.endsWith(DOT_STAR)) {
                ic.addStaticStars(new String[]{extraStaticImport.replace(DOT_STAR, EMPTY_STRING)});
                continue;
            }
            int place = extraStaticImport.lastIndexOf(PERIOD);
            ic.addStaticImport(extraStaticImport.substring(0, place), extraStaticImport.substring(place + 1));
        }
    }

    private void importExtras(ImportCustomizer ic) {
        for (String extraImport : this.extraImports) {
            if (extraImport.endsWith(DOT_STAR)) {
                ic.addStarImports(new String[]{extraImport.replace(DOT_STAR, EMPTY_STRING)});
                continue;
            }
            ic.addImports(new String[]{extraImport});
        }
    }
}

