/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.hadoop.groovy.plugin;

import com.tinkerpop.gremlin.groovy.plugin.AbstractGremlinPlugin;
import com.tinkerpop.gremlin.groovy.plugin.IllegalEnvironmentException;
import com.tinkerpop.gremlin.groovy.plugin.PluginAcceptor;
import com.tinkerpop.gremlin.groovy.plugin.PluginInitializationException;
import com.tinkerpop.gremlin.groovy.plugin.RemoteAcceptor;
import com.tinkerpop.gremlin.hadoop.Constants;
import com.tinkerpop.gremlin.hadoop.groovy.plugin.HadoopLoader;
import com.tinkerpop.gremlin.hadoop.groovy.plugin.HadoopRemoteAcceptor;
import com.tinkerpop.gremlin.hadoop.process.computer.giraph.GiraphGraphComputer;
import com.tinkerpop.gremlin.hadoop.process.computer.mapreduce.MapReduceGraphComputer;
import com.tinkerpop.gremlin.hadoop.structure.HadoopConfiguration;
import com.tinkerpop.gremlin.hadoop.structure.HadoopGraph;
import com.tinkerpop.gremlin.hadoop.structure.hdfs.HDFSTools;
import com.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import com.tinkerpop.gremlin.hadoop.structure.io.graphson.GraphSONInputFormat;
import com.tinkerpop.gremlin.hadoop.structure.io.kryo.KryoInputFormat;
import com.tinkerpop.gremlin.hadoop.structure.io.script.ScriptInputFormat;
import com.tinkerpop.gremlin.hadoop.structure.util.ConfUtil;
import com.tinkerpop.gremlin.process.graph.step.sideEffect.mapreduce.GroupCountMapReduce;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapreduce.Job;

public class HadoopGremlinPlugin
extends AbstractGremlinPlugin {
    private static final Set<String> IMPORTS = new HashSet<String>(){
        {
            this.add("import org.apache.hadoop.hdfs.*");
            this.add("import org.apache.hadoop.conf.*");
            this.add("import org.apache.hadoop.fs.*");
            this.add("import org.apache.hadoop.util.*");
            this.add("import org.apache.hadoop.io.*");
            this.add("import org.apache.hadoop.io.compress.*");
            this.add("import org.apache.hadoop.mapreduce.lib.input.*");
            this.add("import org.apache.hadoop.mapreduce.lib.output.*");
            this.add("import org.apache.log4j.*");
            this.add("import " + Constants.class.getPackage().getName() + ".*");
            this.add("import " + HadoopConfiguration.class.getPackage().getName() + ".*");
            this.add("import " + ConfUtil.class.getPackage().getName() + ".*");
            this.add("import " + VertexWritable.class.getPackage().getName() + ".*");
            this.add("import " + KryoInputFormat.class.getPackage().getName() + ".*");
            this.add("import " + GraphSONInputFormat.class.getPackage().getName() + ".*");
            this.add("import " + ScriptInputFormat.class.getPackage().getName() + ".*");
            this.add("import " + HDFSTools.class.getPackage().getName() + ".*");
            this.add("import " + GroupCountMapReduce.class.getPackage().getName() + ".*");
            this.add("import " + GiraphGraphComputer.class.getPackage().getName() + ".*");
            this.add("import " + MapReduceGraphComputer.class.getPackage().getName() + ".*");
        }
    };

    public String getName() {
        return "tinkerpop.hadoop";
    }

    public void afterPluginTo(PluginAcceptor pluginAcceptor) throws PluginInitializationException, IllegalEnvironmentException {
        pluginAcceptor.addImports(IMPORTS);
        try {
            pluginAcceptor.eval(String.format("Logger.getLogger(%s).setLevel(Level.INFO)", JobClient.class.getName()));
            pluginAcceptor.eval(String.format("Logger.getLogger(%s).setLevel(Level.INFO)", Job.class.getName()));
            pluginAcceptor.eval(String.format("Logger.getLogger(%s).setLevel(Level.INFO)", GiraphGraphComputer.class.getName()));
            pluginAcceptor.eval(String.format("Logger.getLogger(%s).setLevel(Level.INFO)", MapReduceGraphComputer.class.getName()));
            pluginAcceptor.eval(String.format("Logger.getLogger(%s).setLevel(Level.INFO)", HadoopGraph.class.getName()));
            pluginAcceptor.eval(HadoopLoader.class.getCanonicalName() + ".load()");
            pluginAcceptor.addBinding("hdfs", (Object)FileSystem.get((Configuration)new Configuration()));
            pluginAcceptor.addBinding("local", (Object)FileSystem.getLocal((Configuration)new Configuration()));
            if (null == System.getenv("HADOOP_GREMLIN_LIBS")) {
                HadoopGraph.LOGGER.warn("Be sure to set the environmental variable: HADOOP_GREMLIN_LIBS");
            } else {
                HadoopGraph.LOGGER.info("HADOOP_GREMLIN_LIBS is set to: " + System.getenv("HADOOP_GREMLIN_LIBS"));
            }
        }
        catch (Exception e) {
            throw new PluginInitializationException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean requireRestart() {
        return true;
    }

    public Optional<RemoteAcceptor> remoteAcceptor() {
        return Optional.of(new HadoopRemoteAcceptor(this.shell));
    }
}

