/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.hadoop.groovy.plugin;

import com.tinkerpop.gremlin.groovy.engine.GroovyTraversalScript;
import com.tinkerpop.gremlin.groovy.plugin.RemoteAcceptor;
import com.tinkerpop.gremlin.groovy.plugin.RemoteException;
import com.tinkerpop.gremlin.hadoop.structure.HadoopGraph;
import com.tinkerpop.gremlin.process.Step;
import com.tinkerpop.gremlin.process.Traversal;
import com.tinkerpop.gremlin.process.computer.ComputerResult;
import com.tinkerpop.gremlin.process.computer.traversal.TraversalVertexProgram;
import com.tinkerpop.gremlin.process.computer.traversal.step.map.ComputerResultStep;
import com.tinkerpop.gremlin.process.graph.util.DefaultGraphTraversal;
import com.tinkerpop.gremlin.structure.Graph;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.codehaus.groovy.tools.shell.Groovysh;

public class HadoopRemoteAcceptor
implements RemoteAcceptor {
    private static final String USE_SUGAR = "useSugar";
    private static final String SPACE = " ";
    private HadoopGraph hadoopGraph;
    private Groovysh shell;
    private boolean useSugarPlugin = false;
    private String graphVariable = "g";

    public HadoopRemoteAcceptor(Groovysh shell) {
        this.shell = shell;
    }

    public Object connect(List<String> args) throws RemoteException {
        if (args.size() == 0) {
            this.hadoopGraph = HadoopGraph.open((Configuration)new BaseConfiguration());
            this.shell.getInterp().getContext().setProperty("g", (Object)this.hadoopGraph);
        }
        if (args.size() == 1) {
            try {
                PropertiesConfiguration configuration = new PropertiesConfiguration();
                configuration.load(new File(args.get(0)));
                this.hadoopGraph = HadoopGraph.open((Configuration)configuration);
                this.shell.getInterp().getContext().setProperty("g", (Object)this.hadoopGraph);
            }
            catch (Exception e) {
                throw new RemoteException(e.getMessage(), (Throwable)e);
            }
        }
        if (args.size() == 2) {
            try {
                PropertiesConfiguration configuration = new PropertiesConfiguration();
                configuration.load(new File(args.get(0)));
                this.hadoopGraph = HadoopGraph.open((Configuration)configuration);
                this.graphVariable = args.get(1);
                this.shell.getInterp().getContext().setProperty(args.get(1), (Object)this.hadoopGraph);
            }
            catch (Exception e) {
                throw new RemoteException(e.getMessage(), (Throwable)e);
            }
        }
        return this.hadoopGraph;
    }

    public Object configure(List<String> args) throws RemoteException {
        for (int i = 0; i < args.size(); i += 2) {
            if (args.get(i).equals(USE_SUGAR)) {
                this.useSugarPlugin = Boolean.valueOf(args.get(i + 1));
                continue;
            }
            this.hadoopGraph.configuration().setProperty(args.get(i), args.get(i + 1));
        }
        return this.hadoopGraph;
    }

    public Object submit(List<String> args) throws RemoteException {
        try {
            GroovyTraversalScript traversal = GroovyTraversalScript.of((String)RemoteAcceptor.getScript((String)String.join((CharSequence)SPACE, args), (Groovysh)this.shell)).over((Graph)this.hadoopGraph).using(this.hadoopGraph.compute(new Class[0]));
            if (this.useSugarPlugin) {
                traversal.withSugar();
            }
            TraversalVertexProgram vertexProgram = traversal.program();
            ComputerResult computerResult = (ComputerResult)traversal.result().get();
            this.shell.getInterp().getContext().setProperty("result", (Object)computerResult);
            DefaultGraphTraversal traversal2 = new DefaultGraphTraversal(Graph.class);
            traversal2.asAdmin().addStep((Step)new ComputerResultStep((Traversal)traversal2, computerResult, vertexProgram, false));
            traversal2.range(0L, 19L);
            return traversal2;
        }
        catch (Exception e) {
            throw new RemoteException((Throwable)e);
        }
    }

    public void close() throws IOException {
        this.hadoopGraph.close();
    }

    public HadoopGraph getGraph() {
        return this.hadoopGraph;
    }

    public String toString() {
        return "HadoopRemoteAcceptor[" + this.hadoopGraph + "]";
    }
}

