/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.hadoop.process.computer;

import com.tinkerpop.gremlin.hadoop.structure.io.ObjectWritable;
import com.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import com.tinkerpop.gremlin.hadoop.structure.util.ConfUtil;
import com.tinkerpop.gremlin.process.computer.MapReduce;
import java.io.IOException;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopMap
extends Mapper<NullWritable, VertexWritable, ObjectWritable, ObjectWritable> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HadoopMap.class);
    private MapReduce mapReduce;
    private final HadoopMapEmitter<ObjectWritable, ObjectWritable> mapEmitter = new HadoopMapEmitter();

    private HadoopMap() {
    }

    public void setup(Mapper.Context context) {
        this.mapReduce = MapReduce.createMapReduce((Configuration)ConfUtil.makeApacheConfiguration(context.getConfiguration()));
    }

    public void map(NullWritable key, VertexWritable value, Mapper.Context context) throws IOException, InterruptedException {
        this.mapEmitter.setContext(context);
        this.mapReduce.map(value.get(), this.mapEmitter);
    }

    public class HadoopMapEmitter<K, V>
    implements MapReduce.MapEmitter<K, V> {
        private Mapper.Context context;
        private final ObjectWritable<K> keyWritable = new ObjectWritable();
        private final ObjectWritable<V> valueWritable = new ObjectWritable();

        public void setContext(Mapper.Context context) {
            this.context = context;
        }

        public void emit(K key, V value) {
            this.keyWritable.set(key);
            this.valueWritable.set(value);
            try {
                this.context.write(this.keyWritable, this.valueWritable);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }
}

