/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.hadoop.process.computer;

import com.tinkerpop.gremlin.hadoop.structure.io.ObjectWritable;
import com.tinkerpop.gremlin.hadoop.structure.util.ConfUtil;
import com.tinkerpop.gremlin.process.computer.MapReduce;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.mapreduce.Reducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopReduce
extends Reducer<ObjectWritable, ObjectWritable, ObjectWritable, ObjectWritable> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HadoopReduce.class);
    private MapReduce mapReduce;
    private final HadoopReduceEmitter<ObjectWritable, ObjectWritable> reduceEmitter = new HadoopReduceEmitter();

    private HadoopReduce() {
    }

    public void setup(Reducer.Context context) {
        this.mapReduce = MapReduce.createMapReduce((Configuration)ConfUtil.makeApacheConfiguration(context.getConfiguration()));
    }

    public void reduce(ObjectWritable key, Iterable<ObjectWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        final Iterator<ObjectWritable> itty = values.iterator();
        this.reduceEmitter.setContext(context);
        this.mapReduce.reduce(key.get(), new Iterator(){

            @Override
            public boolean hasNext() {
                return itty.hasNext();
            }

            public Object next() {
                return ((ObjectWritable)itty.next()).get();
            }
        }, this.reduceEmitter);
    }

    public class HadoopReduceEmitter<OK, OV>
    implements MapReduce.ReduceEmitter<OK, OV> {
        private Reducer.Context context;
        private final ObjectWritable<OK> keyWritable = new ObjectWritable();
        private final ObjectWritable<OV> valueWritable = new ObjectWritable();

        public void setContext(Reducer.Context context) {
            this.context = context;
        }

        public void emit(OK key, OV value) {
            this.keyWritable.set(key);
            this.valueWritable.set(value);
            try {
                this.context.write(this.keyWritable, this.valueWritable);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }
}

