/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.hadoop.process.computer.giraph;

import com.tinkerpop.gremlin.hadoop.process.computer.giraph.EmptyOutEdges;
import com.tinkerpop.gremlin.hadoop.process.computer.giraph.GiraphMemory;
import com.tinkerpop.gremlin.hadoop.process.computer.giraph.GiraphMessenger;
import com.tinkerpop.gremlin.hadoop.process.computer.giraph.GiraphWorkerContext;
import com.tinkerpop.gremlin.hadoop.process.computer.giraph.RuleWritable;
import com.tinkerpop.gremlin.hadoop.structure.io.ObjectWritable;
import com.tinkerpop.gremlin.process.computer.Memory;
import com.tinkerpop.gremlin.process.computer.Messenger;
import com.tinkerpop.gremlin.process.computer.VertexProgram;
import com.tinkerpop.gremlin.process.computer.util.ComputerDataStrategy;
import com.tinkerpop.gremlin.process.computer.util.MapMemory;
import com.tinkerpop.gremlin.structure.Direction;
import com.tinkerpop.gremlin.structure.Edge;
import com.tinkerpop.gremlin.structure.Graph;
import com.tinkerpop.gremlin.structure.Vertex;
import com.tinkerpop.gremlin.structure.io.kryo.KryoReader;
import com.tinkerpop.gremlin.structure.io.kryo.KryoWriter;
import com.tinkerpop.gremlin.structure.strategy.StrategyVertex;
import com.tinkerpop.gremlin.structure.util.detached.DetachedEdge;
import com.tinkerpop.gremlin.structure.util.detached.DetachedVertex;
import com.tinkerpop.gremlin.structure.util.wrapped.WrappedVertex;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerVertex;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Function;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public final class GiraphComputeVertex
extends org.apache.giraph.graph.Vertex<LongWritable, Text, NullWritable, ObjectWritable>
implements WrappedVertex<TinkerVertex> {
    private static final String VERTEX_ID = Graph.Hidden.hide((String)"giraph.gremlin.vertexId");
    private TinkerVertex tinkerVertex;
    private StrategyVertex wrappedVertex;
    private static KryoWriter KRYO_WRITER = KryoWriter.build().create();
    private static KryoReader KRYO_READER = KryoReader.build().create();

    public GiraphComputeVertex() {
    }

    public GiraphComputeVertex(Vertex vertex) {
        this.tinkerVertex = GiraphComputeVertex.generateTinkerVertexForm(vertex);
        this.tinkerVertex.graph().variables().set(VERTEX_ID, this.tinkerVertex.id());
        this.initialize((WritableComparable)new LongWritable(Long.valueOf(this.tinkerVertex.id().toString()).longValue()), (Writable)this.deflateTinkerVertex(), (Iterable)((Object)EmptyOutEdges.instance()));
    }

    public TinkerVertex getBaseVertex() {
        return this.tinkerVertex;
    }

    public void compute(Iterable<ObjectWritable> messages) {
        VertexProgram<?> vertexProgram = ((GiraphWorkerContext)this.getWorkerContext()).getVertexProgram();
        GiraphMemory memory = ((GiraphWorkerContext)this.getWorkerContext()).getMemory();
        GiraphMessenger messenger = ((GiraphWorkerContext)this.getWorkerContext()).getMessenger(this, messages);
        if (null == this.tinkerVertex) {
            this.inflateTinkerVertex();
        }
        if (null == this.wrappedVertex) {
            this.wrappedVertex = ComputerDataStrategy.wrapVertex((Vertex)this.tinkerVertex, vertexProgram);
        }
        if (!((Boolean)((RuleWritable)this.getAggregatedValue("gremlin.hadoop.halt")).getObject()).booleanValue()) {
            vertexProgram.execute((Vertex)this.wrappedVertex, (Messenger)messenger, (Memory)memory);
        } else if (this.getConf().getBoolean("gremlin.hadoop.deriveMemory", false)) {
            MapMemory mapMemory = new MapMemory();
            memory.asMap().forEach((arg_0, arg_1) -> ((MapMemory)mapMemory).set(arg_0, arg_1));
            mapMemory.setIteration(memory.getIteration() - 1);
            this.wrappedVertex.singleProperty("gremlin.hadoop.mapMemory", (Object)mapMemory, new Object[0]);
        }
    }

    private Text deflateTinkerVertex() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            KRYO_WRITER.writeGraph((OutputStream)bos, this.tinkerVertex.graph());
            bos.flush();
            bos.close();
            return new Text(bos.toByteArray());
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private void inflateTinkerVertex() {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(((Text)this.getValue()).getBytes());
            TinkerGraph tinkerGraph = TinkerGraph.open();
            KRYO_READER.readGraph((InputStream)bis, (Graph)tinkerGraph);
            bis.close();
            this.tinkerVertex = (TinkerVertex)tinkerGraph.iterators().vertexIterator(new Object[]{tinkerGraph.variables().get(VERTEX_ID).get()}).next();
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private static final TinkerVertex generateTinkerVertexForm(Vertex otherVertex) {
        if (otherVertex instanceof TinkerVertex) {
            return (TinkerVertex)otherVertex;
        }
        try {
            TinkerVertex tinkerVertex;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            KRYO_WRITER.writeVertex((OutputStream)bos, otherVertex, Direction.BOTH);
            bos.flush();
            bos.close();
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            TinkerGraph tinkerGraph = TinkerGraph.open();
            Function<DetachedVertex, Vertex> vertexMaker = detachedVertex -> DetachedVertex.addTo((Graph)tinkerGraph, (DetachedVertex)detachedVertex);
            Function<DetachedEdge, Edge> edgeMaker = detachedEdge -> DetachedEdge.addTo((Graph)tinkerGraph, (DetachedEdge)detachedEdge);
            try (ByteArrayInputStream in = new ByteArrayInputStream(bos.toByteArray());){
                tinkerVertex = (TinkerVertex)KRYO_READER.readVertex((InputStream)in, Direction.BOTH, vertexMaker, edgeMaker);
            }
            bis.close();
            return tinkerVertex;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

