/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.hadoop.process.computer.giraph;

import com.tinkerpop.gremlin.hadoop.Constants;
import com.tinkerpop.gremlin.hadoop.process.computer.giraph.EmptyOutEdges;
import com.tinkerpop.gremlin.hadoop.process.computer.giraph.GiraphComputeVertex;
import com.tinkerpop.gremlin.hadoop.process.computer.giraph.GiraphMemory;
import com.tinkerpop.gremlin.hadoop.process.computer.giraph.GiraphMessageCombiner;
import com.tinkerpop.gremlin.hadoop.process.computer.giraph.GiraphWorkerContext;
import com.tinkerpop.gremlin.hadoop.process.computer.giraph.io.GiraphVertexInputFormat;
import com.tinkerpop.gremlin.hadoop.process.computer.giraph.io.GiraphVertexOutputFormat;
import com.tinkerpop.gremlin.hadoop.process.computer.util.MapReduceHelper;
import com.tinkerpop.gremlin.hadoop.process.computer.util.MemoryMapReduce;
import com.tinkerpop.gremlin.hadoop.structure.HadoopConfiguration;
import com.tinkerpop.gremlin.hadoop.structure.HadoopGraph;
import com.tinkerpop.gremlin.hadoop.structure.util.ConfUtil;
import com.tinkerpop.gremlin.hadoop.structure.util.HadoopHelper;
import com.tinkerpop.gremlin.process.computer.ComputerResult;
import com.tinkerpop.gremlin.process.computer.GraphComputer;
import com.tinkerpop.gremlin.process.computer.MapReduce;
import com.tinkerpop.gremlin.process.computer.Memory;
import com.tinkerpop.gremlin.process.computer.VertexProgram;
import com.tinkerpop.gremlin.process.computer.util.ComputerDataStrategy;
import com.tinkerpop.gremlin.process.computer.util.GraphComputerHelper;
import com.tinkerpop.gremlin.process.computer.util.MapMemory;
import com.tinkerpop.gremlin.structure.Graph;
import com.tinkerpop.gremlin.structure.util.StringFactory;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.job.GiraphJob;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GiraphGraphComputer
extends Configured
implements GraphComputer,
Tool {
    public static final Logger LOGGER = LoggerFactory.getLogger(GiraphGraphComputer.class);
    protected final HadoopGraph hadoopGraph;
    protected GiraphConfiguration giraphConfiguration = new GiraphConfiguration();
    private boolean executed = false;
    private final Set<MapReduce> mapReduces = new HashSet<MapReduce>();
    private VertexProgram vertexProgram;
    private MapMemory memory = new MapMemory();

    public GiraphGraphComputer(HadoopGraph hadoopGraph) {
        this.hadoopGraph = hadoopGraph;
        HadoopConfiguration configuration = hadoopGraph.configuration();
        configuration.getKeys().forEachRemaining(arg_0 -> this.lambda$new$0((org.apache.commons.configuration.Configuration)configuration, arg_0));
        this.giraphConfiguration.setMasterComputeClass(GiraphMemory.class);
        this.giraphConfiguration.setVertexClass(GiraphComputeVertex.class);
        this.giraphConfiguration.setWorkerContextClass(GiraphWorkerContext.class);
        this.giraphConfiguration.setOutEdgesClass(EmptyOutEdges.class);
        this.giraphConfiguration.setClass("giraph.vertexIdClass", LongWritable.class, LongWritable.class);
        this.giraphConfiguration.setClass("giraph.vertexValueClass", Text.class, Text.class);
        this.giraphConfiguration.setVertexInputFormatClass(GiraphVertexInputFormat.class);
        this.giraphConfiguration.setVertexOutputFormatClass(GiraphVertexOutputFormat.class);
    }

    public GraphComputer isolation(GraphComputer.Isolation isolation) {
        if (!isolation.equals((Object)GraphComputer.Isolation.BSP)) {
            throw GraphComputer.Exceptions.isolationNotSupported((GraphComputer.Isolation)isolation);
        }
        return this;
    }

    public GraphComputer program(VertexProgram vertexProgram) {
        this.vertexProgram = vertexProgram;
        this.memory.addVertexProgramMemoryComputeKeys(this.vertexProgram);
        BaseConfiguration apacheConfiguration = new BaseConfiguration();
        vertexProgram.storeState((org.apache.commons.configuration.Configuration)apacheConfiguration);
        ConfUtil.mergeApacheIntoHadoopConfiguration((org.apache.commons.configuration.Configuration)apacheConfiguration, (Configuration)this.giraphConfiguration);
        this.vertexProgram.getMessageCombiner().ifPresent(combiner -> this.giraphConfiguration.setCombinerClass(GiraphMessageCombiner.class));
        return this;
    }

    public GraphComputer mapReduce(MapReduce mapReduce) {
        this.mapReduces.add(mapReduce);
        return this;
    }

    public String toString() {
        return StringFactory.graphComputerString((GraphComputer)this);
    }

    public Future<ComputerResult> submit() {
        if (this.executed) {
            throw GraphComputer.Exceptions.computerHasAlreadyBeenSubmittedAVertexProgram();
        }
        this.executed = true;
        if (null == this.vertexProgram && this.mapReduces.isEmpty()) {
            throw GraphComputer.Exceptions.computerHasNoVertexProgramNorMapReducers();
        }
        if (null != this.vertexProgram) {
            GraphComputerHelper.validateProgramOnComputer((GraphComputer)this, (VertexProgram)this.vertexProgram);
        }
        long startTime = System.currentTimeMillis();
        return CompletableFuture.supplyAsync(() -> {
            try {
                FileSystem fs = FileSystem.get((Configuration)this.giraphConfiguration);
                this.loadJars(fs);
                fs.delete(new Path(this.giraphConfiguration.get("gremlin.hadoop.outputLocation")), true);
                ToolRunner.run((Tool)this, (String[])new String[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
            this.memory.setRuntime(System.currentTimeMillis() - startTime);
            HadoopGraph outputGraph = HadoopHelper.getOutputGraph(this.hadoopGraph);
            return new ComputerResult((Graph)(null == this.vertexProgram ? outputGraph : ComputerDataStrategy.wrapGraph((Graph)outputGraph, (VertexProgram)this.vertexProgram)), this.memory.asImmutable());
        });
    }

    public int run(String[] args) {
        try {
            if (null != this.vertexProgram) {
                GiraphJob job = new GiraphJob(this.giraphConfiguration, "HadoopGremlin(Giraph): " + this.vertexProgram);
                Path inputPath = new Path(this.giraphConfiguration.get("gremlin.hadoop.inputLocation"));
                if (!FileSystem.get((Configuration)this.giraphConfiguration).exists(inputPath)) {
                    throw new IllegalArgumentException("The provided input path does not exist: " + inputPath);
                }
                FileInputFormat.setInputPaths((Job)job.getInternalJob(), (Path[])new Path[]{inputPath});
                FileOutputFormat.setOutputPath((Job)job.getInternalJob(), (Path)new Path(this.giraphConfiguration.get("gremlin.hadoop.outputLocation") + "/" + Constants.SYSTEM_G));
                LOGGER.info("HadoopGremlin(Giraph): " + this.vertexProgram);
                if (!job.run(true)) {
                    throw new IllegalStateException("The GiraphGraphComputer job failed -- aborting all subsequent MapReduce jobs");
                }
                this.mapReduces.addAll(this.vertexProgram.getMapReducers());
                if (this.giraphConfiguration.getBoolean("gremlin.hadoop.deriveMemory", false)) {
                    HashSet<String> memoryKeys = new HashSet<String>(this.vertexProgram.getMemoryComputeKeys());
                    memoryKeys.add(Constants.SYSTEM_ITERATION);
                    this.giraphConfiguration.setStrings("gremlin.hadoop.memoryKeys", memoryKeys.toArray(new String[memoryKeys.size()]));
                    this.mapReduces.add((MapReduce)new MemoryMapReduce(memoryKeys));
                }
            }
            for (MapReduce mapReduce : this.mapReduces) {
                this.memory.addMapReduceMemoryKey(mapReduce);
                MapReduceHelper.executeMapReduceJob(mapReduce, (Memory.Admin)this.memory, (Configuration)this.giraphConfiguration);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return 0;
    }

    private void loadJars(FileSystem fs) {
        String hadoopGremlinLibsRemote = "hadoop-gremlin-libs";
        if (this.giraphConfiguration.getBoolean("gremlin.hadoop.jarsInDistributedCache", true)) {
            String giraphGremlinLibsLocal = System.getenv("HADOOP_GREMLIN_LIBS");
            if (null == giraphGremlinLibsLocal) {
                LOGGER.warn("HADOOP_GREMLIN_LIBS is not set -- proceeding regardless");
            } else {
                String[] paths;
                for (String path : paths = giraphGremlinLibsLocal.split(":")) {
                    File file = new File(path);
                    if (file.exists()) {
                        Stream.of(file.listFiles()).filter(f -> f.getName().endsWith(".jar")).forEach(f -> {
                            try {
                                Path jarFile = new Path(fs.getHomeDirectory() + "/" + "hadoop-gremlin-libs" + "/" + f.getName());
                                fs.copyFromLocalFile(new Path(f.getPath()), jarFile);
                                try {
                                    DistributedCache.addArchiveToClassPath((Path)jarFile, (Configuration)this.giraphConfiguration, (FileSystem)fs);
                                }
                                catch (Exception e) {
                                    throw new RuntimeException(e.getMessage(), e);
                                }
                            }
                            catch (Exception e) {
                                throw new IllegalStateException(e.getMessage(), e);
                            }
                        });
                        continue;
                    }
                    LOGGER.warn(path + " does not reference a valid directory -- proceeding regardless");
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            PropertiesConfiguration configuration = new PropertiesConfiguration();
            configuration.load(new File(args[0]));
            GiraphGraphComputer computer = new GiraphGraphComputer(HadoopGraph.open((org.apache.commons.configuration.Configuration)configuration));
            computer.program(VertexProgram.createVertexProgram((org.apache.commons.configuration.Configuration)configuration)).submit().get();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private /* synthetic */ void lambda$new$0(org.apache.commons.configuration.Configuration configuration, String key) {
        this.giraphConfiguration.set(key, configuration.getProperty(key).toString());
    }
}

