/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.hadoop.process.computer.giraph;

import com.tinkerpop.gremlin.hadoop.Constants;
import com.tinkerpop.gremlin.hadoop.process.computer.giraph.GiraphWorkerContext;
import com.tinkerpop.gremlin.hadoop.process.computer.giraph.MemoryAggregator;
import com.tinkerpop.gremlin.hadoop.process.computer.giraph.RuleWritable;
import com.tinkerpop.gremlin.hadoop.structure.util.ConfUtil;
import com.tinkerpop.gremlin.process.computer.GraphComputer;
import com.tinkerpop.gremlin.process.computer.Memory;
import com.tinkerpop.gremlin.process.computer.VertexProgram;
import com.tinkerpop.gremlin.process.computer.util.MemoryHelper;
import com.tinkerpop.gremlin.structure.util.StringFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.giraph.master.MasterCompute;

public class GiraphMemory
extends MasterCompute
implements Memory {
    private VertexProgram vertexProgram;
    private GiraphWorkerContext worker;
    private Set<String> memoryKeys;
    private boolean isMasterCompute = true;

    public GiraphMemory() {
    }

    public GiraphMemory(GiraphWorkerContext worker, VertexProgram vertexProgram) {
        this.worker = worker;
        this.vertexProgram = vertexProgram;
        this.memoryKeys = new HashSet<String>(this.vertexProgram.getMemoryComputeKeys());
        this.isMasterCompute = false;
    }

    public void initialize() {
    }

    public void compute() {
        this.isMasterCompute = true;
        if (0L == this.getSuperstep()) {
            this.vertexProgram = VertexProgram.createVertexProgram((Configuration)ConfUtil.makeApacheConfiguration((org.apache.hadoop.conf.Configuration)this.getConf()));
            this.memoryKeys = new HashSet<String>(this.vertexProgram.getMemoryComputeKeys());
            try {
                for (String key : this.memoryKeys) {
                    MemoryHelper.validateKey((String)key);
                    this.registerPersistentAggregator(key, MemoryAggregator.class);
                }
                this.registerPersistentAggregator("gremlin.hadoop.halt", MemoryAggregator.class);
                this.registerPersistentAggregator(Constants.SYSTEM_RUNTIME, MemoryAggregator.class);
                this.setAggregatedValue("gremlin.hadoop.halt", new RuleWritable(RuleWritable.Rule.SET, false));
                this.set(Constants.SYSTEM_RUNTIME, System.currentTimeMillis());
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
            this.vertexProgram.setup((Memory)this);
        } else if (((Boolean)this.get("gremlin.hadoop.halt")).booleanValue()) {
            this.haltComputation();
        } else if (this.vertexProgram.terminate((Memory)this)) {
            if (!this.getConf().getBoolean("gremlin.hadoop.deriveMemory", false)) {
                this.haltComputation();
            } else {
                this.setAggregatedValue("gremlin.hadoop.halt", new RuleWritable(RuleWritable.Rule.SET, true));
            }
        }
    }

    public int getIteration() {
        if (this.isMasterCompute) {
            int temp = (int)this.getSuperstep();
            return temp == 0 ? temp : temp - 1;
        }
        return (int)this.worker.getSuperstep();
    }

    public long getRuntime() {
        return System.currentTimeMillis() - (Long)this.get(Constants.SYSTEM_RUNTIME);
    }

    public Set<String> keys() {
        return this.memoryKeys;
    }

    public boolean exists(String key) {
        RuleWritable rule = this.isMasterCompute ? (RuleWritable)this.getAggregatedValue(key) : (RuleWritable)this.worker.getAggregatedValue(key);
        return null != rule.getObject();
    }

    public <R> R get(String key) throws IllegalArgumentException {
        RuleWritable rule;
        RuleWritable ruleWritable = rule = this.isMasterCompute ? (RuleWritable)this.getAggregatedValue(key) : (RuleWritable)this.worker.getAggregatedValue(key);
        if (null == rule.getObject()) {
            throw Memory.Exceptions.memoryDoesNotExist((String)key);
        }
        return (R)rule.getObject();
    }

    public void set(String key, Object value) {
        this.checkKeyValue(key, value);
        if (this.isMasterCompute) {
            this.setAggregatedValue(key, new RuleWritable(RuleWritable.Rule.SET, value));
        } else {
            this.worker.aggregate(key, new RuleWritable(RuleWritable.Rule.SET, value));
        }
    }

    public boolean and(String key, boolean bool) {
        this.checkKeyValue(key, bool);
        if (this.isMasterCompute) {
            Boolean value = (Boolean)((RuleWritable)this.getAggregatedValue(key)).getObject();
            value = null == value ? bool : bool && value != false;
            this.setAggregatedValue(key, new RuleWritable(RuleWritable.Rule.AND, value));
            return value;
        }
        Boolean result = (Boolean)((RuleWritable)this.worker.getAggregatedValue(key)).getObject();
        this.worker.aggregate(key, new RuleWritable(RuleWritable.Rule.AND, bool));
        return null == result ? bool : result != false && bool;
    }

    public boolean or(String key, boolean bool) {
        this.checkKeyValue(key, bool);
        if (this.isMasterCompute) {
            Boolean value = (Boolean)((RuleWritable)this.getAggregatedValue(key)).getObject();
            value = null == value ? bool : bool || value != false;
            this.setAggregatedValue(key, new RuleWritable(RuleWritable.Rule.OR, value));
            return value;
        }
        Boolean result = (Boolean)((RuleWritable)this.worker.getAggregatedValue(key)).getObject();
        this.worker.aggregate(key, new RuleWritable(RuleWritable.Rule.OR, bool));
        return null == result ? bool : result != false || bool;
    }

    public long incr(String key, long delta) {
        this.checkKeyValue(key, delta);
        if (this.isMasterCompute) {
            Number value = (Number)((RuleWritable)this.getAggregatedValue(key)).getObject();
            value = null == value ? delta : value.longValue() + delta;
            this.setAggregatedValue(key, new RuleWritable(RuleWritable.Rule.INCR, value));
            return value.longValue();
        }
        Long result = (Long)((RuleWritable)this.worker.getAggregatedValue(key)).getObject();
        this.worker.aggregate(key, new RuleWritable(RuleWritable.Rule.INCR, delta));
        return null == result ? delta : result + delta;
    }

    public void write(DataOutput output) {
    }

    public void readFields(DataInput input) {
    }

    public String toString() {
        return StringFactory.memoryString((Memory)this);
    }

    private void checkKeyValue(String key, Object value) {
        if (!key.equals(Constants.SYSTEM_RUNTIME) && !this.memoryKeys.contains(key)) {
            throw GraphComputer.Exceptions.providedKeyIsNotAMemoryComputeKey((String)key);
        }
        MemoryHelper.validateValue((Object)value);
    }
}

