/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.hadoop.process.computer.giraph;

import com.tinkerpop.gremlin.hadoop.process.computer.giraph.GiraphComputeVertex;
import com.tinkerpop.gremlin.hadoop.structure.io.ObjectWritable;
import com.tinkerpop.gremlin.process.Step;
import com.tinkerpop.gremlin.process.Traversal;
import com.tinkerpop.gremlin.process.computer.MessageScope;
import com.tinkerpop.gremlin.process.computer.Messenger;
import com.tinkerpop.gremlin.process.graph.step.map.VertexStep;
import com.tinkerpop.gremlin.process.graph.step.sideEffect.StartStep;
import com.tinkerpop.gremlin.process.util.TraversalHelper;
import com.tinkerpop.gremlin.structure.Direction;
import com.tinkerpop.gremlin.structure.Edge;
import com.tinkerpop.gremlin.structure.Vertex;
import com.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class GiraphMessenger<M>
implements Messenger<M> {
    private GiraphComputeVertex giraphComputeVertex;
    private Iterable<ObjectWritable<M>> messages;

    public void setCurrentVertex(GiraphComputeVertex giraphComputeVertex, Iterable<ObjectWritable<M>> messages) {
        this.giraphComputeVertex = giraphComputeVertex;
        this.messages = messages;
    }

    public Iterable<M> receiveMessages(MessageScope messageScope) {
        return IteratorUtils.map(this.messages, ObjectWritable::get);
    }

    public void sendMessage(MessageScope messageScope, M message) {
        if (messageScope instanceof MessageScope.Local) {
            MessageScope.Local localMessageScope = (MessageScope.Local)messageScope;
            Object incidentTraversal = GiraphMessenger.setVertexStart((Traversal<Vertex, Edge>)((Traversal)localMessageScope.getIncidentTraversal().get()), (Vertex)this.giraphComputeVertex.getBaseVertex());
            Direction direction = GiraphMessenger.getOppositeDirection(incidentTraversal);
            incidentTraversal.forEachRemaining(edge -> this.giraphComputeVertex.sendMessage((WritableComparable)new LongWritable(Long.valueOf(((Vertex)edge.iterators().vertexIterator(direction).next()).id().toString()).longValue()), (Writable)new ObjectWritable(localMessageScope.getEdgeFunction().apply(message, edge))));
        } else {
            MessageScope.Global globalMessageScope = (MessageScope.Global)messageScope;
            globalMessageScope.vertices().forEach(vertex -> this.giraphComputeVertex.sendMessage((WritableComparable)new LongWritable(Long.valueOf(vertex.id().toString()).longValue()), (Writable)new ObjectWritable<Object>(message)));
        }
    }

    private static <T extends Traversal.Admin<Vertex, Edge>> T setVertexStart(Traversal<Vertex, Edge> incidentTraversal, Vertex vertex) {
        incidentTraversal.asAdmin().addStep(0, (Step)new StartStep(incidentTraversal, (Object)vertex));
        return (T)((Traversal.Admin)incidentTraversal);
    }

    private static Direction getOppositeDirection(Traversal.Admin<Vertex, Edge> incidentTraversal) {
        VertexStep step = (VertexStep)TraversalHelper.getLastStepOfAssignableClass(VertexStep.class, incidentTraversal).get();
        return step.getDirection().opposite();
    }
}

