/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.hadoop.process.computer.giraph;

import com.tinkerpop.gremlin.hadoop.process.computer.giraph.GiraphComputeVertex;
import com.tinkerpop.gremlin.hadoop.process.computer.giraph.GiraphMemory;
import com.tinkerpop.gremlin.hadoop.process.computer.giraph.GiraphMessenger;
import com.tinkerpop.gremlin.hadoop.structure.io.ObjectWritable;
import com.tinkerpop.gremlin.hadoop.structure.util.ConfUtil;
import com.tinkerpop.gremlin.process.computer.Memory;
import com.tinkerpop.gremlin.process.computer.VertexProgram;
import com.tinkerpop.gremlin.process.computer.util.ImmutableMemory;
import org.apache.commons.configuration.Configuration;
import org.apache.giraph.worker.WorkerContext;

public final class GiraphWorkerContext
extends WorkerContext {
    private VertexProgram<?> vertexProgram;
    private GiraphMemory memory;
    private GiraphMessenger messenger;

    public void preApplication() throws InstantiationException, IllegalAccessException {
        this.vertexProgram = VertexProgram.createVertexProgram((Configuration)ConfUtil.makeApacheConfiguration(this.getContext().getConfiguration()));
        this.memory = new GiraphMemory(this, this.vertexProgram);
        this.messenger = new GiraphMessenger();
    }

    public void postApplication() {
    }

    public void preSuperstep() {
        this.vertexProgram.workerIterationStart((Memory)new ImmutableMemory((Memory)this.memory));
    }

    public void postSuperstep() {
        this.vertexProgram.workerIterationEnd((Memory)new ImmutableMemory((Memory)this.memory));
    }

    public VertexProgram<?> getVertexProgram() {
        return this.vertexProgram;
    }

    public GiraphMemory getMemory() {
        return this.memory;
    }

    public GiraphMessenger getMessenger(GiraphComputeVertex giraphComputeVertex, Iterable<ObjectWritable> messages) {
        this.messenger.setCurrentVertex(giraphComputeVertex, messages);
        return this.messenger;
    }
}

