/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.hadoop.process.computer.giraph;

import com.tinkerpop.gremlin.hadoop.process.computer.giraph.RuleWritable;
import org.apache.giraph.aggregators.Aggregator;

public class MemoryAggregator
implements Aggregator<RuleWritable> {
    private Object value = null;
    private RuleWritable.Rule lastRule = null;

    public RuleWritable getAggregatedValue() {
        if (null == this.value) {
            return this.createInitialValue();
        }
        if (this.value instanceof Long) {
            return new RuleWritable(RuleWritable.Rule.INCR, this.value);
        }
        return new RuleWritable(null == this.lastRule ? RuleWritable.Rule.NO_OP : this.lastRule, this.value);
    }

    public void setAggregatedValue(RuleWritable rule) {
        this.value = rule.getObject();
    }

    public void reset() {
        this.value = null;
    }

    public RuleWritable createInitialValue() {
        return new RuleWritable(RuleWritable.Rule.NO_OP, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void aggregate(RuleWritable ruleWritable) {
        RuleWritable.Rule rule = ruleWritable.getRule();
        Object object = ruleWritable.getObject();
        if (rule != RuleWritable.Rule.NO_OP) {
            this.lastRule = rule;
        }
        if (null == this.value || rule.equals((Object)RuleWritable.Rule.SET)) {
            this.value = object;
            return;
        } else if (rule.equals((Object)RuleWritable.Rule.INCR)) {
            this.value = (Long)this.value + (Long)object;
            return;
        } else if (rule.equals((Object)RuleWritable.Rule.AND)) {
            this.value = (Boolean)this.value != false && (Boolean)object != false;
            return;
        } else if (rule.equals((Object)RuleWritable.Rule.OR)) {
            this.value = (Boolean)this.value != false || (Boolean)object != false;
            return;
        } else {
            if (!rule.equals((Object)RuleWritable.Rule.NO_OP)) throw new IllegalArgumentException("The provided rule is unknown: " + ruleWritable);
            if (!(object instanceof Boolean) || null == this.lastRule) return;
            if (this.lastRule.equals((Object)RuleWritable.Rule.AND)) {
                this.value = (Boolean)this.value != false && (Boolean)object != false;
                return;
            } else {
                if (!this.lastRule.equals((Object)RuleWritable.Rule.OR)) throw new IllegalStateException("This state should not have occurred: " + ruleWritable);
                this.value = (Boolean)this.value != false || (Boolean)object != false;
            }
        }
    }
}

