/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.hadoop.process.computer.giraph;

import com.tinkerpop.gremlin.util.Serializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

public class RuleWritable
implements Writable {
    private Rule rule;
    private Object object;

    public RuleWritable() {
    }

    public RuleWritable(Rule rule, Object object) {
        this.rule = rule;
        this.object = object;
    }

    public <T> T getObject() {
        return (T)this.object;
    }

    public Rule getRule() {
        return this.rule;
    }

    public void readFields(DataInput input) throws IOException {
        this.rule = Rule.values()[WritableUtils.readVInt((DataInput)input)];
        int objectLength = WritableUtils.readVInt((DataInput)input);
        byte[] objectBytes = new byte[objectLength];
        for (int i = 0; i < objectLength; ++i) {
            objectBytes[i] = input.readByte();
        }
        try {
            this.object = Serializer.deserializeObject((byte[])objectBytes);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public void write(DataOutput output) throws IOException {
        WritableUtils.writeVInt((DataOutput)output, (int)this.rule.ordinal());
        byte[] objectBytes = Serializer.serializeObject((Object)this.object);
        WritableUtils.writeVInt((DataOutput)output, (int)objectBytes.length);
        output.write(objectBytes);
    }

    public String toString() {
        return (Object)((Object)this.rule) + ":" + this.object;
    }

    public static enum Rule {
        OR,
        AND,
        INCR,
        SET,
        NO_OP;

    }
}

