/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.hadoop.process.computer.giraph.io;

import com.tinkerpop.gremlin.hadoop.process.computer.giraph.GiraphComputeVertex;
import com.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import java.io.IOException;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.VertexReader;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class GiraphVertexReader
extends VertexReader {
    private RecordReader<NullWritable, VertexWritable> recordReader;

    public GiraphVertexReader(RecordReader<NullWritable, VertexWritable> recordReader) {
        this.recordReader = recordReader;
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        this.recordReader.initialize(inputSplit, context);
    }

    public boolean nextVertex() throws IOException, InterruptedException {
        return this.recordReader.nextKeyValue();
    }

    public Vertex getCurrentVertex() throws IOException, InterruptedException {
        return new GiraphComputeVertex(((VertexWritable)this.recordReader.getCurrentValue()).get());
    }

    public void close() throws IOException {
        this.recordReader.close();
    }

    public float getProgress() throws IOException, InterruptedException {
        return this.recordReader.getProgress();
    }
}

