/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.hadoop.process.computer.giraph.io;

import com.tinkerpop.gremlin.hadoop.process.computer.giraph.GiraphComputeVertex;
import com.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import com.tinkerpop.gremlin.structure.Vertex;
import java.io.IOException;
import org.apache.giraph.io.VertexWriter;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class GiraphVertexWriter
extends VertexWriter {
    private final OutputFormat<NullWritable, VertexWritable> outputFormat;
    private RecordWriter<NullWritable, VertexWritable> recordWriter;

    public GiraphVertexWriter(OutputFormat<NullWritable, VertexWritable> outputFormat) {
        this.outputFormat = outputFormat;
    }

    public void initialize(TaskAttemptContext context) throws IOException, InterruptedException {
        this.recordWriter = this.outputFormat.getRecordWriter(context);
    }

    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        this.recordWriter.close(context);
    }

    public void writeVertex(org.apache.giraph.graph.Vertex vertex) throws IOException, InterruptedException {
        this.recordWriter.write((Object)NullWritable.get(), new VertexWritable((Vertex)((GiraphComputeVertex)vertex).getBaseVertex()));
    }
}

