/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.hadoop.process.computer.util;

import com.tinkerpop.gremlin.hadoop.Constants;
import com.tinkerpop.gremlin.hadoop.process.computer.HadoopCombine;
import com.tinkerpop.gremlin.hadoop.process.computer.HadoopMap;
import com.tinkerpop.gremlin.hadoop.process.computer.HadoopReduce;
import com.tinkerpop.gremlin.hadoop.structure.HadoopGraph;
import com.tinkerpop.gremlin.hadoop.structure.io.ObjectWritable;
import com.tinkerpop.gremlin.hadoop.structure.io.ObjectWritableComparator;
import com.tinkerpop.gremlin.hadoop.structure.io.ObjectWritableIterator;
import com.tinkerpop.gremlin.hadoop.structure.util.ConfUtil;
import com.tinkerpop.gremlin.process.computer.MapReduce;
import com.tinkerpop.gremlin.process.computer.Memory;
import java.io.IOException;
import java.util.Iterator;
import java.util.Optional;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;

public class MapReduceHelper {
    private static final String SEQUENCE_WARNING = "The gremlin.hadoop.memoryOutputFormat is not " + SequenceFileOutputFormat.class.getCanonicalName() + " and thus, graph computer memory can not be converted to Java objects";

    public static void executeMapReduceJob(MapReduce mapReduce, Memory.Admin memory, org.apache.hadoop.conf.Configuration configuration) throws IOException, ClassNotFoundException, InterruptedException {
        org.apache.hadoop.conf.Configuration newConfiguration = new org.apache.hadoop.conf.Configuration(configuration);
        BaseConfiguration apacheConfiguration = new BaseConfiguration();
        mapReduce.storeState((Configuration)apacheConfiguration);
        ConfUtil.mergeApacheIntoHadoopConfiguration((Configuration)apacheConfiguration, newConfiguration);
        if (!mapReduce.doStage(MapReduce.Stage.MAP)) {
            Path memoryPath = new Path(configuration.get("gremlin.hadoop.outputLocation") + "/" + mapReduce.getMemoryKey());
            if (newConfiguration.getClass("gremlin.hadoop.graphOutputFormat", SequenceFileOutputFormat.class, OutputFormat.class).equals(SequenceFileOutputFormat.class)) {
                mapReduce.addResultToMemory(memory, (Iterator)new ObjectWritableIterator(configuration, memoryPath));
            } else {
                HadoopGraph.LOGGER.warn(SEQUENCE_WARNING);
            }
        } else {
            Optional mapSort = mapReduce.getMapKeySort();
            Optional reduceSort = mapReduce.getReduceKeySort();
            newConfiguration.setClass("gremlin.hadoop.mapReduceClass", mapReduce.getClass(), MapReduce.class);
            Job job = new Job(newConfiguration, mapReduce.toString());
            HadoopGraph.LOGGER.info("HadoopGremlin: " + mapReduce.toString());
            job.setJarByClass(HadoopGraph.class);
            if (mapSort.isPresent()) {
                job.setSortComparatorClass(ObjectWritableComparator.ObjectWritableMapComparator.class);
            }
            job.setMapperClass(HadoopMap.class);
            if (mapReduce.doStage(MapReduce.Stage.REDUCE)) {
                if (mapReduce.doStage(MapReduce.Stage.COMBINE)) {
                    job.setCombinerClass(HadoopCombine.class);
                }
                job.setReducerClass(HadoopReduce.class);
            } else if (mapSort.isPresent()) {
                job.setReducerClass(Reducer.class);
            } else {
                job.setNumReduceTasks(0);
            }
            job.setMapOutputKeyClass(ObjectWritable.class);
            job.setMapOutputValueClass(ObjectWritable.class);
            job.setOutputKeyClass(ObjectWritable.class);
            job.setOutputValueClass(ObjectWritable.class);
            job.setInputFormatClass(newConfiguration.getClass("gremlin.hadoop.graphInputFormat", InputFormat.class));
            job.setOutputFormatClass(newConfiguration.getClass("gremlin.hadoop.memoryOutputFormat", SequenceFileOutputFormat.class, OutputFormat.class));
            Path graphPath = configuration.get("gremlin.vertexProgram", null) != null ? new Path(newConfiguration.get("gremlin.hadoop.outputLocation") + "/" + Constants.SYSTEM_G) : new Path(newConfiguration.get("gremlin.hadoop.inputLocation"));
            Path memoryPath = new Path(newConfiguration.get("gremlin.hadoop.outputLocation") + "/" + (reduceSort.isPresent() ? mapReduce.getMemoryKey() + "-temp" : mapReduce.getMemoryKey()));
            if (FileSystem.get((org.apache.hadoop.conf.Configuration)newConfiguration).exists(memoryPath)) {
                FileSystem.get((org.apache.hadoop.conf.Configuration)newConfiguration).delete(memoryPath, true);
            }
            FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{graphPath});
            FileOutputFormat.setOutputPath((Job)job, (Path)memoryPath);
            job.waitForCompletion(true);
            if (reduceSort.isPresent()) {
                Job reduceSortJob = new Job(newConfiguration, "ReduceKeySort");
                reduceSortJob.setSortComparatorClass(ObjectWritableComparator.ObjectWritableReduceComparator.class);
                reduceSortJob.setMapperClass(Mapper.class);
                reduceSortJob.setReducerClass(Reducer.class);
                reduceSortJob.setMapOutputKeyClass(ObjectWritable.class);
                reduceSortJob.setMapOutputValueClass(ObjectWritable.class);
                reduceSortJob.setOutputKeyClass(ObjectWritable.class);
                reduceSortJob.setOutputValueClass(ObjectWritable.class);
                reduceSortJob.setInputFormatClass(SequenceFileInputFormat.class);
                reduceSortJob.setOutputFormatClass(newConfiguration.getClass("gremlin.hadoop.memoryOutputFormat", SequenceFileOutputFormat.class, OutputFormat.class));
                FileInputFormat.setInputPaths((Job)reduceSortJob, (Path[])new Path[]{memoryPath});
                Path sortedMemoryPath = new Path(newConfiguration.get("gremlin.hadoop.outputLocation") + "/" + mapReduce.getMemoryKey());
                FileOutputFormat.setOutputPath((Job)reduceSortJob, (Path)sortedMemoryPath);
                reduceSortJob.waitForCompletion(true);
                FileSystem.get((org.apache.hadoop.conf.Configuration)newConfiguration).delete(memoryPath, true);
                memoryPath = sortedMemoryPath;
            }
            if (newConfiguration.getClass("gremlin.hadoop.memoryOutputFormat", SequenceFileOutputFormat.class, OutputFormat.class).equals(SequenceFileOutputFormat.class)) {
                mapReduce.addResultToMemory(memory, (Iterator)new ObjectWritableIterator(configuration, memoryPath));
            } else {
                HadoopGraph.LOGGER.warn(SEQUENCE_WARNING);
            }
        }
    }
}

