/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.hadoop.process.computer.util;

import com.tinkerpop.gremlin.hadoop.Constants;
import com.tinkerpop.gremlin.process.computer.KeyValue;
import com.tinkerpop.gremlin.process.computer.MapReduce;
import com.tinkerpop.gremlin.process.computer.Memory;
import com.tinkerpop.gremlin.process.computer.util.GraphComputerHelper;
import com.tinkerpop.gremlin.process.computer.util.MapMemory;
import com.tinkerpop.gremlin.process.computer.util.StaticMapReduce;
import com.tinkerpop.gremlin.structure.Vertex;
import com.tinkerpop.gremlin.structure.util.StringFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.configuration.Configuration;

public class MemoryMapReduce
extends StaticMapReduce<MapReduce.NullObject, MapMemory, MapReduce.NullObject, MapMemory, MapMemory> {
    public Set<String> memoryKeys = new HashSet<String>();

    public String getMemoryKey() {
        return Constants.SYSTEM_MEMORY;
    }

    private MemoryMapReduce() {
    }

    public MemoryMapReduce(Set<String> memoryKeys) {
        this.memoryKeys = memoryKeys;
    }

    public void storeState(Configuration configuration) {
        super.storeState(configuration);
        configuration.setProperty("gremlin.hadoop.memoryKeys", new ArrayList(this.memoryKeys.size()));
    }

    public void loadState(Configuration configuration) {
        this.memoryKeys = new HashSet<String>(configuration.getList("gremlin.hadoop.memoryKeys"));
    }

    public boolean doStage(MapReduce.Stage stage) {
        return true;
    }

    public void map(Vertex vertex, MapReduce.MapEmitter<MapReduce.NullObject, MapMemory> emitter) {
        MapMemory mapMemory = (MapMemory)vertex.property("gremlin.hadoop.mapMemory").orElse((Object)new MapMemory());
        emitter.emit((Object)mapMemory);
    }

    public void combine(MapReduce.NullObject key, Iterator<MapMemory> values, MapReduce.ReduceEmitter<MapReduce.NullObject, MapMemory> emitter) {
        this.reduce(key, values, emitter);
    }

    public void reduce(MapReduce.NullObject key, Iterator<MapMemory> values, MapReduce.ReduceEmitter<MapReduce.NullObject, MapMemory> emitter) {
        emitter.emit((Object)key, (Object)values.next());
    }

    public MapMemory generateFinalResult(Iterator<KeyValue<MapReduce.NullObject, MapMemory>> keyValues) {
        return (MapMemory)keyValues.next().getValue();
    }

    public void addResultToMemory(Memory.Admin memory, Iterator<KeyValue<MapReduce.NullObject, MapMemory>> keyValues) {
        MapMemory temp = (MapMemory)keyValues.next().getValue();
        temp.asMap().forEach((arg_0, arg_1) -> ((Memory.Admin)memory).set(arg_0, arg_1));
        memory.setIteration(temp.getIteration());
        memory.setRuntime(temp.getRuntime());
    }

    public int hashCode() {
        return (((Object)((Object)this)).getClass().getCanonicalName() + Constants.SYSTEM_MEMORY).hashCode();
    }

    public boolean equals(Object object) {
        return GraphComputerHelper.areEqual((MapReduce)this, (Object)object);
    }

    public String toString() {
        return StringFactory.mapReduceString((MapReduce)this, (String)this.memoryKeys.toString());
    }
}

