/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.hadoop.structure;

import com.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import com.tinkerpop.gremlin.util.StreamFactory;
import java.io.Serializable;
import java.util.Iterator;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapreduce.InputFormat;
import org.javatuples.Pair;

public class HadoopConfiguration
extends BaseConfiguration
implements Serializable,
Iterable {
    public HadoopConfiguration() {
    }

    public HadoopConfiguration(Configuration configuration) {
        this.copy(configuration);
    }

    public Class<InputFormat<NullWritable, VertexWritable>> getGraphInputFormat() {
        try {
            return Class.forName(this.getString("gremlin.hadoop.graphInputFormat"));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void setGraphInputFormat(Class<InputFormat<NullWritable, VertexWritable>> inputFormatClass) {
        this.setProperty("gremlin.hadoop.graphInputFormat", inputFormatClass);
    }

    public Class<OutputFormat<NullWritable, VertexWritable>> getGraphOutputFormat() {
        try {
            return Class.forName(this.getString("gremlin.hadoop.graphOutputFormat"));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void setGraphOutputFormat(Class<OutputFormat<NullWritable, VertexWritable>> outputFormatClass) {
        this.setProperty("gremlin.hadoop.graphOutputFormat", outputFormatClass);
    }

    public String getInputLocation() {
        return this.getString("gremlin.hadoop.inputLocation");
    }

    public void setInputLocation(String inputLocation) {
        this.setProperty("gremlin.hadoop.inputLocation", inputLocation);
    }

    public String getOutputLocation() {
        return this.getString("gremlin.hadoop.outputLocation");
    }

    public void setOutputLocation(String outputLocation) {
        this.setProperty("gremlin.hadoop.outputLocation", outputLocation);
    }

    public Iterator iterator() {
        return StreamFactory.stream((Iterator)this.getKeys()).map(k -> new Pair(k, this.getProperty((String)k))).iterator();
    }
}

