/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.hadoop.structure;

import com.tinkerpop.gremlin.hadoop.process.computer.giraph.GiraphGraphComputer;
import com.tinkerpop.gremlin.hadoop.process.graph.strategy.HadoopElementStepStrategy;
import com.tinkerpop.gremlin.hadoop.structure.HadoopConfiguration;
import com.tinkerpop.gremlin.hadoop.structure.HadoopEdge;
import com.tinkerpop.gremlin.hadoop.structure.HadoopVertex;
import com.tinkerpop.gremlin.hadoop.structure.hdfs.HadoopEdgeIterator;
import com.tinkerpop.gremlin.hadoop.structure.hdfs.HadoopVertexIterator;
import com.tinkerpop.gremlin.hadoop.structure.util.ConfUtil;
import com.tinkerpop.gremlin.process.TraversalStrategies;
import com.tinkerpop.gremlin.process.TraversalStrategy;
import com.tinkerpop.gremlin.process.computer.GraphComputer;
import com.tinkerpop.gremlin.process.computer.util.GraphComputerHelper;
import com.tinkerpop.gremlin.structure.Edge;
import com.tinkerpop.gremlin.structure.Graph;
import com.tinkerpop.gremlin.structure.Transaction;
import com.tinkerpop.gremlin.structure.Vertex;
import com.tinkerpop.gremlin.structure.util.ElementHelper;
import com.tinkerpop.gremlin.structure.util.StringFactory;
import com.tinkerpop.gremlin.util.iterator.IteratorUtils;
import java.io.IOException;
import java.util.Iterator;
import java.util.Optional;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapreduce.InputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Graph.OptIns(value={@Graph.OptIn(value="com.tinkerpop.gremlin.structure.StructureStandardSuite"), @Graph.OptIn(value="com.tinkerpop.gremlin.process.ProcessStandardSuite"), @Graph.OptIn(value="com.tinkerpop.gremlin.process.ProcessComputerSuite"), @Graph.OptIn(value="com.tinkerpop.gremlin.process.GroovyProcessStandardSuite"), @Graph.OptIn(value="com.tinkerpop.gremlin.process.GroovyProcessComputerSuite")})
@Graph.OptOuts(value={@Graph.OptOut(test="com.tinkerpop.gremlin.process.graph.step.map.MatchTest$StandardTest", method="g_V_matchXa_hasXname_GarciaX__a_0writtenBy_b__a_0sungBy_bX", reason="Hadoop-Gremlin is OLAP-oriented and for OLTP operations, linear-scan joins are required. This particular tests takes many minutes to execute."), @Graph.OptOut(test="com.tinkerpop.gremlin.process.graph.step.map.MatchTest$StandardTest", method="g_V_matchXa_0sungBy_b__a_0sungBy_c__b_writtenBy_d__c_writtenBy_e__d_hasXname_George_HarisonX__e_hasXname_Bob_MarleyXX", reason="Hadoop-Gremlin is OLAP-oriented and for OLTP operations, linear-scan joins are required. This particular tests takes many minutes to execute."), @Graph.OptOut(test="com.tinkerpop.gremlin.process.graph.step.map.MatchTest$StandardTest", method="g_V_matchXa_0sungBy_b__a_0writtenBy_c__b_writtenBy_d__c_sungBy_d__d_hasXname_GarciaXX", reason="Hadoop-Gremlin is OLAP-oriented and for OLTP operations, linear-scan joins are required. This particular tests takes many minutes to execute."), @Graph.OptOut(test="com.tinkerpop.gremlin.process.graph.step.map.GroovyMatchTest$StandardTest", method="g_V_matchXa_hasXname_GarciaX__a_0writtenBy_b__a_0sungBy_bX", reason="Hadoop-Gremlin is OLAP-oriented and for OLTP operations, linear-scan joins are required. This particular tests takes many minutes to execute."), @Graph.OptOut(test="com.tinkerpop.gremlin.process.graph.step.map.GroovyMatchTest$StandardTest", method="g_V_matchXa_0sungBy_b__a_0sungBy_c__b_writtenBy_d__c_writtenBy_e__d_hasXname_George_HarisonX__e_hasXname_Bob_MarleyXX", reason="Hadoop-Gremlin is OLAP-oriented and for OLTP operations, linear-scan joins are required. This particular tests takes many minutes to execute."), @Graph.OptOut(test="com.tinkerpop.gremlin.process.graph.step.map.GroovyMatchTest$StandardTest", method="g_V_matchXa_0sungBy_b__a_0writtenBy_c__b_writtenBy_d__c_sungBy_d__d_hasXname_GarciaXX", reason="Hadoop-Gremlin is OLAP-oriented and for OLTP operations, linear-scan joins are required. This particular tests takes many minutes to execute."), @Graph.OptOut(test="com.tinkerpop.gremlin.process.graph.step.sideEffect.CountTest$StandardTest", method="g_V_both_both_count", reason="Hadoop-Gremlin is OLAP-oriented and for OLTP operations, linear-scan joins are required. This particular tests takes many minutes to execute."), @Graph.OptOut(test="com.tinkerpop.gremlin.process.graph.step.sideEffect.CountTest$StandardTest", method="g_V_repeatXoutX_timesX3X_count", reason="Hadoop-Gremlin is OLAP-oriented and for OLTP operations, linear-scan joins are required. This particular tests takes many minutes to execute."), @Graph.OptOut(test="com.tinkerpop.gremlin.process.graph.step.sideEffect.CountTest$StandardTest", method="g_V_repeatXoutX_timesX8X_count", reason="Hadoop-Gremlin is OLAP-oriented and for OLTP operations, linear-scan joins are required. This particular tests takes many minutes to execute."), @Graph.OptOut(test="com.tinkerpop.gremlin.process.graph.step.sideEffect.GroovyCountTest$StandardTest", method="g_V_both_both_count", reason="Hadoop-Gremlin is OLAP-oriented and for OLTP operations, linear-scan joins are required. This particular tests takes many minutes to execute."), @Graph.OptOut(test="com.tinkerpop.gremlin.process.graph.step.sideEffect.GroovyCountTest$StandardTest", method="g_V_repeatXoutX_timesX3X_count", reason="Hadoop-Gremlin is OLAP-oriented and for OLTP operations, linear-scan joins are required. This particular tests takes many minutes to execute."), @Graph.OptOut(test="com.tinkerpop.gremlin.process.graph.step.sideEffect.GroovyCountTest$StandardTest", method="g_V_repeatXoutX_timesX8X_count", reason="Hadoop-Gremlin is OLAP-oriented and for OLTP operations, linear-scan joins are required. This particular tests takes many minutes to execute."), @Graph.OptOut(test="com.tinkerpop.gremlin.process.computer.GroovyGraphComputerTest$ComputerTest", method="shouldNotAllowNullMemoryKeys", reason="Hadoop does a hard kill on failure and stops threads which stops test cases. Exception handling semantics are correct though."), @Graph.OptOut(test="com.tinkerpop.gremlin.process.computer.GroovyGraphComputerTest$ComputerTest", method="shouldNotAllowSettingUndeclaredMemoryKeys", reason="Hadoop does a hard kill on failure and stops threads which stops test cases. Exception handling semantics are correct though."), @Graph.OptOut(test="com.tinkerpop.gremlin.process.computer.GroovyGraphComputerTest$ComputerTest", method="shouldHaveConsistentMemoryVertexPropertiesAndExceptions", reason="Hadoop does a hard kill on failure and stops threads which stops test cases. Exception handling semantics are correct though.")})
public class HadoopGraph
implements Graph,
Graph.Iterators {
    public static final Logger LOGGER;
    private static final org.apache.commons.configuration.Configuration EMPTY_CONFIGURATION;
    protected final HadoopConfiguration configuration;

    private HadoopGraph(org.apache.commons.configuration.Configuration configuration) {
        this.configuration = new HadoopConfiguration(configuration);
    }

    public static HadoopGraph open() {
        return HadoopGraph.open(null);
    }

    public static HadoopGraph open(org.apache.commons.configuration.Configuration configuration) {
        return new HadoopGraph(Optional.ofNullable(configuration).orElse(EMPTY_CONFIGURATION));
    }

    public Vertex addVertex(Object ... keyValues) {
        throw Graph.Exceptions.vertexAdditionsNotSupported();
    }

    public GraphComputer compute(Class ... graphComputerClass) {
        GraphComputerHelper.validateComputeArguments((Class[])graphComputerClass);
        if (graphComputerClass.length == 0 || graphComputerClass[0].equals(GiraphGraphComputer.class)) {
            return new GiraphGraphComputer(this);
        }
        throw Graph.Exceptions.graphDoesNotSupportProvidedGraphComputer((Class)graphComputerClass[0]);
    }

    public Graph.Variables variables() {
        throw Graph.Exceptions.variablesNotSupported();
    }

    public HadoopConfiguration configuration() {
        return this.configuration;
    }

    public String toString() {
        Configuration hadoopConfiguration = ConfUtil.makeHadoopConfiguration((org.apache.commons.configuration.Configuration)this.configuration);
        String fromString = this.configuration.containsKey("gremlin.hadoop.graphInputFormat") ? hadoopConfiguration.getClass("gremlin.hadoop.graphInputFormat", InputFormat.class).getSimpleName() : "no-input";
        String toString = this.configuration.containsKey("gremlin.hadoop.graphOutputFormat") ? hadoopConfiguration.getClass("gremlin.hadoop.graphOutputFormat", OutputFormat.class).getSimpleName() : "no-output";
        return StringFactory.graphString((Graph)this, (String)(fromString.toLowerCase() + "->" + toString.toLowerCase()));
    }

    public void close() {
        this.configuration.clear();
    }

    public Transaction tx() {
        throw Graph.Exceptions.transactionsNotSupported();
    }

    public Graph.Iterators iterators() {
        return this;
    }

    public Iterator<Vertex> vertexIterator(Object ... vertexIds) {
        try {
            return 0 == vertexIds.length ? new HadoopVertexIterator(this) : IteratorUtils.filter((Iterator)new HadoopVertexIterator(this), vertex -> ElementHelper.idExists((Object)vertex.id(), (Object[])vertexIds));
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public Iterator<Edge> edgeIterator(Object ... edgeIds) {
        try {
            return 0 == edgeIds.length ? new HadoopEdgeIterator(this) : IteratorUtils.filter((Iterator)new HadoopEdgeIterator(this), edge -> ElementHelper.idExists((Object)edge.id(), (Object[])edgeIds));
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public Graph.Features features() {
        return new HadoopGraphFeatures();
    }

    static {
        try {
            TraversalStrategies.GlobalCache.registerStrategies(HadoopVertex.class, (TraversalStrategies)TraversalStrategies.GlobalCache.getStrategies(Vertex.class).clone().addStrategies(new TraversalStrategy[]{HadoopElementStepStrategy.instance()}));
            TraversalStrategies.GlobalCache.registerStrategies(HadoopEdge.class, (TraversalStrategies)TraversalStrategies.GlobalCache.getStrategies(Edge.class).clone().addStrategies(new TraversalStrategy[]{HadoopElementStepStrategy.instance()}));
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        LOGGER = LoggerFactory.getLogger(HadoopGraph.class);
        EMPTY_CONFIGURATION = new BaseConfiguration(){
            {
                this.setProperty("gremlin.graph", HadoopGraph.class.getName());
            }
        };
    }

    public static class HadoopGraphFeatures
    implements Graph.Features {
        public Graph.Features.GraphFeatures graph() {
            return new Graph.Features.GraphFeatures(){

                public boolean supportsTransactions() {
                    return false;
                }

                public boolean supportsThreadedTransactions() {
                    return false;
                }

                public Graph.Features.VariableFeatures variables() {
                    return new Graph.Features.VariableFeatures(){

                        public boolean supportsVariables() {
                            return false;
                        }

                        public boolean supportsBooleanValues() {
                            return false;
                        }

                        public boolean supportsByteValues() {
                            return false;
                        }

                        public boolean supportsDoubleValues() {
                            return false;
                        }

                        public boolean supportsFloatValues() {
                            return false;
                        }

                        public boolean supportsIntegerValues() {
                            return false;
                        }

                        public boolean supportsLongValues() {
                            return false;
                        }

                        public boolean supportsMapValues() {
                            return false;
                        }

                        public boolean supportsMixedListValues() {
                            return false;
                        }

                        public boolean supportsBooleanArrayValues() {
                            return false;
                        }

                        public boolean supportsByteArrayValues() {
                            return false;
                        }

                        public boolean supportsDoubleArrayValues() {
                            return false;
                        }

                        public boolean supportsFloatArrayValues() {
                            return false;
                        }

                        public boolean supportsIntegerArrayValues() {
                            return false;
                        }

                        public boolean supportsStringArrayValues() {
                            return false;
                        }

                        public boolean supportsLongArrayValues() {
                            return false;
                        }

                        public boolean supportsSerializableValues() {
                            return false;
                        }

                        public boolean supportsStringValues() {
                            return false;
                        }

                        public boolean supportsUniformListValues() {
                            return false;
                        }
                    };
                }
            };
        }

        public Graph.Features.EdgeFeatures edge() {
            return new Graph.Features.EdgeFeatures(){

                public boolean supportsAddEdges() {
                    return false;
                }

                public boolean supportsAddProperty() {
                    return false;
                }

                public boolean supportsCustomIds() {
                    return false;
                }
            };
        }

        public Graph.Features.VertexFeatures vertex() {
            return new Graph.Features.VertexFeatures(){

                public boolean supportsAddVertices() {
                    return false;
                }

                public boolean supportsAddProperty() {
                    return false;
                }

                public boolean supportsCustomIds() {
                    return false;
                }

                public Graph.Features.VertexPropertyFeatures properties() {
                    return new Graph.Features.VertexPropertyFeatures(){

                        public boolean supportsAddProperty() {
                            return false;
                        }
                    };
                }
            };
        }

        public String toString() {
            return StringFactory.featureString((Graph.Features)this);
        }
    }
}

