/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.hadoop.structure.hdfs;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.CompressionInputStream;

public class HDFSTools {
    private static final String FORWARD_SLASH = "/";
    private static final String FORWARD_ASTERISK = "/*";

    protected HDFSTools() {
    }

    public static long getFileSize(FileSystem fs, Path path, PathFilter filter) throws IOException {
        long totalSize = 0L;
        for (Path p : HDFSTools.getAllFilePaths(fs, path, filter)) {
            totalSize += fs.getFileStatus(p).getLen();
        }
        return totalSize;
    }

    public static List<Path> getAllFilePaths(FileSystem fs, Path path, PathFilter filter) throws IOException {
        if (null == path) {
            path = fs.getHomeDirectory();
        }
        if (path.toString().equals(FORWARD_SLASH)) {
            path = new Path("");
        }
        ArrayList<Path> paths = new ArrayList<Path>();
        if (fs.isFile(path)) {
            paths.add(path);
        } else {
            for (FileStatus status : fs.globStatus(new Path(path + FORWARD_ASTERISK), filter)) {
                Path next = status.getPath();
                paths.addAll(HDFSTools.getAllFilePaths(fs, next, filter));
            }
        }
        return paths;
    }

    public static void decompressPath(FileSystem fs, String in, String out, String compressedFileSuffix, boolean deletePrevious) throws IOException {
        Path inPath = new Path(in);
        if (fs.isFile(inPath)) {
            HDFSTools.decompressFile(fs, in, out, deletePrevious);
        } else {
            Path outPath = new Path(out);
            if (!fs.exists(outPath)) {
                fs.mkdirs(outPath);
            }
            for (Path path : FileUtil.stat2Paths((FileStatus[])fs.globStatus(new Path(in + FORWARD_ASTERISK)))) {
                if (!path.getName().endsWith(compressedFileSuffix)) continue;
                HDFSTools.decompressFile(fs, path.toString(), outPath.toString() + FORWARD_SLASH + path.getName().split("\\.")[0], deletePrevious);
            }
        }
    }

    public static void decompressFile(FileSystem fs, String inFile, String outFile, boolean deletePrevious) throws IOException {
        Path inPath = new Path(inFile);
        Path outPath = new Path(outFile);
        CompressionCodecFactory factory = new CompressionCodecFactory(new Configuration());
        CompressionCodec codec = factory.getCodec(inPath);
        FSDataOutputStream out = fs.create(outPath);
        CompressionInputStream in = codec.createInputStream((InputStream)fs.open(inPath));
        IOUtils.copyBytes((InputStream)in, (OutputStream)out, (int)8192);
        IOUtils.closeStream((Closeable)in);
        IOUtils.closeStream((Closeable)out);
        if (deletePrevious) {
            fs.delete(new Path(inFile), true);
        }
    }

    public static boolean globDelete(FileSystem fs, String path, boolean recursive) throws IOException {
        boolean deleted = false;
        for (Path p : FileUtil.stat2Paths((FileStatus[])fs.globStatus(new Path(path)))) {
            fs.delete(p, recursive);
            deleted = true;
        }
        return deleted;
    }
}

