/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.hadoop.structure.hdfs;

import com.tinkerpop.gremlin.hadoop.structure.HadoopGraph;
import com.tinkerpop.gremlin.hadoop.structure.hdfs.HiddenFileFilter;
import com.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import com.tinkerpop.gremlin.hadoop.structure.util.ConfUtil;
import com.tinkerpop.gremlin.structure.Element;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public abstract class HadoopElementIterator<E extends Element>
implements Iterator<E> {
    protected final HadoopGraph graph;
    protected final Queue<RecordReader<NullWritable, VertexWritable>> readers = new LinkedList<RecordReader<NullWritable, VertexWritable>>();

    public HadoopElementIterator(HadoopGraph graph, InputFormat<NullWritable, VertexWritable> inputFormat, Path path) throws IOException, InterruptedException {
        this.graph = graph;
        org.apache.hadoop.conf.Configuration configuration = ConfUtil.makeHadoopConfiguration((Configuration)this.graph.configuration());
        for (FileStatus status : FileSystem.get((org.apache.hadoop.conf.Configuration)configuration).listStatus(path, (PathFilter)HiddenFileFilter.instance())) {
            this.readers.add((RecordReader<NullWritable, VertexWritable>)inputFormat.createRecordReader((InputSplit)new FileSplit(status.getPath(), 0L, Integer.MAX_VALUE, new String[0]), new TaskAttemptContext(configuration, new TaskAttemptID())));
        }
    }

    public HadoopElementIterator(HadoopGraph graph) throws IOException {
        try {
            this.graph = graph;
            if (this.graph.configuration().containsKey("gremlin.hadoop.inputLocation")) {
                org.apache.hadoop.conf.Configuration configuration = ConfUtil.makeHadoopConfiguration((Configuration)this.graph.configuration());
                InputFormat<NullWritable, VertexWritable> inputFormat = this.graph.configuration().getGraphInputFormat().getConstructor(new Class[0]).newInstance(new Object[0]);
                for (FileStatus status : FileSystem.get((org.apache.hadoop.conf.Configuration)configuration).listStatus(new Path(graph.configuration().getInputLocation()), (PathFilter)HiddenFileFilter.instance())) {
                    this.readers.add((RecordReader<NullWritable, VertexWritable>)inputFormat.createRecordReader((InputSplit)new FileSplit(status.getPath(), 0L, Integer.MAX_VALUE, new String[0]), new TaskAttemptContext(configuration, new TaskAttemptID())));
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

