/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.hadoop.structure.hdfs;

import com.tinkerpop.gremlin.hadoop.structure.HadoopGraph;
import com.tinkerpop.gremlin.hadoop.structure.HadoopVertex;
import com.tinkerpop.gremlin.hadoop.structure.hdfs.HadoopElementIterator;
import com.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import com.tinkerpop.gremlin.process.util.FastNoSuchElementException;
import com.tinkerpop.gremlin.structure.Vertex;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.RecordReader;

public class HadoopVertexIterator
extends HadoopElementIterator<Vertex> {
    private HadoopVertex nextVertex = null;

    public HadoopVertexIterator(HadoopGraph graph, InputFormat<NullWritable, VertexWritable> inputFormat, Path path) throws IOException, InterruptedException {
        super(graph, inputFormat, path);
    }

    public HadoopVertexIterator(HadoopGraph graph) throws IOException {
        super(graph);
    }

    @Override
    public Vertex next() {
        try {
            if (this.nextVertex != null) {
                HadoopVertex temp = this.nextVertex;
                this.nextVertex = null;
                return temp;
            }
            while (!this.readers.isEmpty()) {
                if (((RecordReader)this.readers.peek()).nextKeyValue()) {
                    return new HadoopVertex(((VertexWritable)((RecordReader)this.readers.peek()).getCurrentValue()).get(), this.graph);
                }
                this.readers.remove();
            }
            throw FastNoSuchElementException.instance();
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public boolean hasNext() {
        try {
            if (null != this.nextVertex) {
                return true;
            }
            while (!this.readers.isEmpty()) {
                if (((RecordReader)this.readers.peek()).nextKeyValue()) {
                    this.nextVertex = new HadoopVertex(((VertexWritable)((RecordReader)this.readers.peek()).getCurrentValue()).get(), this.graph);
                    return true;
                }
                this.readers.remove();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return false;
    }
}

