/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.hadoop.structure.hdfs;

import com.tinkerpop.gremlin.hadoop.structure.hdfs.HiddenFileFilter;
import com.tinkerpop.gremlin.process.util.FastNoSuchElementException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;

public class TextIterator
implements Iterator<String> {
    private String line;
    private boolean available = false;
    private final Queue<BufferedReader> readers = new LinkedList<BufferedReader>();

    public TextIterator(Configuration configuration, Path path) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)configuration);
        for (FileStatus status : fs.listStatus(path, (PathFilter)HiddenFileFilter.instance())) {
            this.readers.add(new BufferedReader(new InputStreamReader((InputStream)fs.open(status.getPath()))));
        }
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.available) {
                return true;
            }
            while (true) {
                if (this.readers.isEmpty()) {
                    return false;
                }
                this.line = this.readers.peek().readLine();
                if (this.line != null) {
                    this.available = true;
                    return true;
                }
                this.readers.remove();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public String next() {
        try {
            if (this.available) {
                this.available = false;
                return this.line;
            }
            while (true) {
                if (this.readers.isEmpty()) {
                    throw FastNoSuchElementException.instance();
                }
                this.line = this.readers.peek().readLine();
                if (this.line != null) {
                    return this.line;
                }
                this.readers.remove();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

