/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.hadoop.structure.io;

import com.tinkerpop.gremlin.util.Serializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableUtils;

public final class ObjectWritable<T>
implements WritableComparable<ObjectWritable> {
    T t;

    public ObjectWritable() {
    }

    public ObjectWritable(T t) {
        this.t = t;
    }

    public T get() {
        return this.t;
    }

    public void set(T t) {
        this.t = t;
    }

    public String toString() {
        return this.t.toString();
    }

    public void readFields(DataInput input) throws IOException {
        try {
            this.t = Serializer.deserializeObject((byte[])WritableUtils.readCompressedByteArray((DataInput)input));
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public void write(DataOutput output) throws IOException {
        WritableUtils.writeCompressedByteArray((DataOutput)output, (byte[])Serializer.serializeObject(this.t));
    }

    public int compareTo(ObjectWritable objectWritable) {
        return this.t instanceof Comparable ? ((Comparable)this.t).compareTo(objectWritable.get()) : 0;
    }

    public boolean isEmpty() {
        return null == this.t;
    }

    public static ObjectWritable empty() {
        return new ObjectWritable<Object>(null);
    }

    public boolean equals(Object other) {
        if (!(other instanceof ObjectWritable)) {
            return false;
        }
        if (this.isEmpty()) {
            return ((ObjectWritable)other).isEmpty();
        }
        return this.t.equals(((ObjectWritable)other).get());
    }

    public int hashCode() {
        return this.isEmpty() ? 0 : this.t.hashCode();
    }
}

