/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.hadoop.structure.io;

import com.tinkerpop.gremlin.hadoop.structure.hdfs.HiddenFileFilter;
import com.tinkerpop.gremlin.hadoop.structure.io.ObjectWritable;
import com.tinkerpop.gremlin.process.computer.KeyValue;
import com.tinkerpop.gremlin.process.util.FastNoSuchElementException;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;

public class ObjectWritableIterator
implements Iterator<KeyValue> {
    private final ObjectWritable key = new ObjectWritable();
    private final ObjectWritable value = new ObjectWritable();
    private boolean available = false;
    private final Queue<SequenceFile.Reader> readers = new LinkedList<SequenceFile.Reader>();

    public ObjectWritableIterator(Configuration configuration, Path path) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)configuration);
        for (FileStatus status : fs.listStatus(path, (PathFilter)HiddenFileFilter.instance())) {
            this.readers.add(new SequenceFile.Reader(fs, status.getPath(), configuration));
        }
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.available) {
                return true;
            }
            while (true) {
                if (this.readers.isEmpty()) {
                    return false;
                }
                if (this.readers.peek().next((Writable)this.key, (Writable)this.value)) {
                    this.available = true;
                    return true;
                }
                this.readers.remove();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public KeyValue next() {
        try {
            if (this.available) {
                this.available = false;
                return new KeyValue(this.key.get(), this.value.get());
            }
            while (true) {
                if (this.readers.isEmpty()) {
                    throw FastNoSuchElementException.instance();
                }
                if (this.readers.peek().next((Writable)this.key, (Writable)this.value)) {
                    return new KeyValue(this.key.get(), this.value.get());
                }
                this.readers.remove();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

