/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.hadoop.structure.io.graphson;

import com.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import com.tinkerpop.gremlin.hadoop.structure.io.graphson.GraphSONRecordReader;
import java.io.IOException;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;

public class GraphSONInputFormat
extends FileInputFormat<NullWritable, VertexWritable>
implements Configurable {
    private Configuration config;

    public RecordReader<NullWritable, VertexWritable> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        GraphSONRecordReader reader = new GraphSONRecordReader();
        reader.initialize(split, context);
        return reader;
    }

    protected boolean isSplitable(JobContext context, Path file) {
        return null == new CompressionCodecFactory(context.getConfiguration()).getCodec(file);
    }

    public void setConf(Configuration config) {
        this.config = config;
    }

    public Configuration getConf() {
        return this.config;
    }
}

