/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.hadoop.structure.io.graphson;

import com.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import com.tinkerpop.gremlin.structure.Direction;
import com.tinkerpop.gremlin.structure.Edge;
import com.tinkerpop.gremlin.structure.Graph;
import com.tinkerpop.gremlin.structure.Vertex;
import com.tinkerpop.gremlin.structure.io.graphson.GraphSONReader;
import com.tinkerpop.gremlin.structure.util.detached.DetachedEdge;
import com.tinkerpop.gremlin.structure.util.detached.DetachedVertex;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerVertex;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Function;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.LineRecordReader;

public class GraphSONRecordReader
extends RecordReader<NullWritable, VertexWritable> {
    private final LineRecordReader lineRecordReader = new LineRecordReader();
    private static final GraphSONReader GRAPHSON_READER = GraphSONReader.build().create();
    private VertexWritable vertex = null;

    public void initialize(InputSplit genericSplit, TaskAttemptContext context) throws IOException {
        this.lineRecordReader.initialize(genericSplit, context);
    }

    public boolean nextKeyValue() throws IOException {
        TinkerVertex v;
        if (!this.lineRecordReader.nextKeyValue()) {
            return false;
        }
        TinkerGraph g = TinkerGraph.open();
        Function<DetachedVertex, Vertex> vertexMaker = detachedVertex -> DetachedVertex.addTo((Graph)g, (DetachedVertex)detachedVertex);
        Function<DetachedEdge, Edge> edgeMaker = detachedEdge -> DetachedEdge.addTo((Graph)g, (DetachedEdge)detachedEdge);
        try (ByteArrayInputStream in = new ByteArrayInputStream(this.lineRecordReader.getCurrentValue().getBytes());){
            v = (TinkerVertex)GRAPHSON_READER.readVertex((InputStream)in, Direction.BOTH, vertexMaker, edgeMaker);
        }
        this.vertex = new VertexWritable((Vertex)v);
        return true;
    }

    public NullWritable getCurrentKey() {
        return NullWritable.get();
    }

    public VertexWritable getCurrentValue() {
        return this.vertex;
    }

    public float getProgress() throws IOException {
        return this.lineRecordReader.getProgress();
    }

    public synchronized void close() throws IOException {
        this.lineRecordReader.close();
    }
}

