/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.hadoop.structure.io.graphson;

import com.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import com.tinkerpop.gremlin.structure.Direction;
import com.tinkerpop.gremlin.structure.io.graphson.GraphSONWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class GraphSONRecordWriter
extends RecordWriter<NullWritable, VertexWritable> {
    private static final String UTF8 = "UTF-8";
    private static final byte[] NEWLINE;
    private final DataOutputStream out;
    private static final GraphSONWriter GRAPHSON_WRITER;

    public GraphSONRecordWriter(DataOutputStream out) {
        this.out = out;
    }

    public void write(NullWritable key, VertexWritable vertex) throws IOException {
        if (null != vertex) {
            GRAPHSON_WRITER.writeVertex((OutputStream)this.out, vertex.get(), Direction.BOTH);
            this.out.write(NEWLINE);
        }
    }

    public synchronized void close(TaskAttemptContext context) throws IOException {
        this.out.close();
    }

    static {
        GRAPHSON_WRITER = GraphSONWriter.build().create();
        try {
            NEWLINE = "\n".getBytes(UTF8);
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalArgumentException("Can not find UTF-8 encoding");
        }
    }
}

