/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.hadoop.structure.io.kryo;

import com.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import com.tinkerpop.gremlin.hadoop.structure.io.kryo.VertexStreamIterator;
import com.tinkerpop.gremlin.structure.io.kryo.KryoMapper;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class KryoRecordReader
extends RecordReader<NullWritable, VertexWritable> {
    private VertexStreamIterator vertexStreamIterator;
    private FSDataInputStream inputStream;
    private static final byte[] PATTERN = KryoMapper.build().create().getVersionedHeader();

    public void initialize(InputSplit genericSplit, TaskAttemptContext context) throws IOException {
        FileSplit split = (FileSplit)genericSplit;
        Configuration job = context.getConfiguration();
        long start = split.getStart();
        Path file = split.getPath();
        if (null != new CompressionCodecFactory(job).getCodec(file)) {
            throw new IllegalStateException("Compression is not supported for the (binary) Gremlin Kryo format");
        }
        this.inputStream = file.getFileSystem(job).open(split.getPath());
        this.inputStream.seek(start);
        long newStart = KryoRecordReader.seekToHeader(this.inputStream, start);
        this.vertexStreamIterator = new VertexStreamIterator((InputStream)this.inputStream, split.getLength() - (newStart - start));
    }

    private static long seekToHeader(FSDataInputStream inputStream, long start) throws IOException {
        long nextStart = start;
        byte[] buffer = new byte[32];
        while (true) {
            if ((buffer[0] = PATTERN[0]) == inputStream.readByte()) {
                inputStream.read(nextStart + 1L, buffer, 1, 31);
                if (!KryoRecordReader.patternMatch(buffer)) continue;
                inputStream.seek(nextStart);
                return nextStart;
            }
            inputStream.seek(++nextStart);
        }
    }

    private static boolean patternMatch(byte[] bytes) {
        for (int i = 0; i < 31; ++i) {
            if (bytes[i] == PATTERN[i]) continue;
            return false;
        }
        return true;
    }

    public boolean nextKeyValue() throws IOException {
        return this.vertexStreamIterator.hasNext();
    }

    public NullWritable getCurrentKey() {
        return NullWritable.get();
    }

    public VertexWritable getCurrentValue() {
        return this.vertexStreamIterator.next();
    }

    public float getProgress() throws IOException {
        return this.vertexStreamIterator.getProgress();
    }

    public synchronized void close() throws IOException {
        this.inputStream.close();
    }
}

