/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.hadoop.structure.io.kryo;

import com.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import com.tinkerpop.gremlin.structure.Direction;
import com.tinkerpop.gremlin.structure.io.kryo.KryoWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class KryoRecordWriter
extends RecordWriter<NullWritable, VertexWritable> {
    private final DataOutputStream out;
    private static final KryoWriter KRYO_WRITER = KryoWriter.build().create();

    public KryoRecordWriter(DataOutputStream out) {
        this.out = out;
    }

    public void write(NullWritable key, VertexWritable vertex) throws IOException {
        if (null != vertex) {
            KRYO_WRITER.writeVertex((OutputStream)this.out, vertex.get(), Direction.BOTH);
        }
    }

    public synchronized void close(TaskAttemptContext context) throws IOException {
        this.out.close();
    }
}

