/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.hadoop.structure.io.kryo;

import com.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import com.tinkerpop.gremlin.structure.Direction;
import com.tinkerpop.gremlin.structure.Edge;
import com.tinkerpop.gremlin.structure.Graph;
import com.tinkerpop.gremlin.structure.Vertex;
import com.tinkerpop.gremlin.structure.io.kryo.KryoReader;
import com.tinkerpop.gremlin.structure.util.detached.DetachedEdge;
import com.tinkerpop.gremlin.structure.util.detached.DetachedVertex;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.function.Function;

public class VertexStreamIterator
implements Iterator<VertexWritable> {
    private static final int[] TERMINATOR = new int[]{58, 21, 138, 17, 112, 155, 153, 150};
    private static int BUFLEN = TERMINATOR.length;
    private final InputStream inputStream;
    private static final KryoReader KRYO_READER = KryoReader.build().create();
    private final ByteArrayOutputStream output = new ByteArrayOutputStream();
    private final int[] buffer = new int[BUFLEN];
    private int len;
    private int currentByte;
    private Vertex currentVertex;
    private final long maxLength;
    private long currentLength = 0L;

    public VertexStreamIterator(InputStream inputStream, long maxLength) {
        this.inputStream = inputStream;
        this.maxLength = maxLength;
    }

    public float getProgress() {
        if (0L == this.currentLength || 0L == this.maxLength) {
            return 0.0f;
        }
        if (this.currentLength >= this.maxLength || this.maxLength == Long.MAX_VALUE) {
            return 1.0f;
        }
        return (float)this.currentLength / (float)this.maxLength;
    }

    @Override
    public boolean hasNext() {
        if (this.currentLength >= this.maxLength) {
            return false;
        }
        if (null != this.currentVertex) {
            return true;
        }
        if (-1 == this.currentByte) {
            return false;
        }
        try {
            this.currentVertex = this.advanceToNextVertex();
            return null != this.currentVertex;
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public VertexWritable next() {
        try {
            if (null == this.currentVertex) {
                if (this.hasNext()) {
                    VertexWritable vertexWritable = new VertexWritable(this.currentVertex);
                    return vertexWritable;
                }
                throw new IllegalStateException("There are no more vertices in this split");
            }
            VertexWritable vertexWritable = new VertexWritable(this.currentVertex);
            return vertexWritable;
        }
        finally {
            this.currentVertex = null;
            this.len = 0;
            this.output.reset();
        }
    }

    private final Vertex advanceToNextVertex() throws IOException {
        while (true) {
            this.currentByte = this.inputStream.read();
            ++this.currentLength;
            if (-1 == this.currentByte) {
                if (this.len > 0) {
                    throw new IllegalStateException("Remainder of stream exhausted without matching a vertex");
                }
                return null;
            }
            if (this.len >= BUFLEN) {
                this.output.write(this.buffer[this.len % BUFLEN]);
            }
            this.buffer[this.len % VertexStreamIterator.BUFLEN] = this.currentByte;
            ++this.len;
            if (this.len <= BUFLEN) continue;
            boolean terminated = true;
            for (int i = 0; i < BUFLEN; ++i) {
                if (this.buffer[(this.len + i) % BUFLEN] == TERMINATOR[i]) continue;
                terminated = false;
                break;
            }
            if (terminated) break;
        }
        TinkerGraph gLocal = TinkerGraph.open();
        Function<DetachedVertex, Vertex> vertexMaker = arg_0 -> VertexStreamIterator.lambda$advanceToNextVertex$19((Graph)gLocal, arg_0);
        Function<DetachedEdge, Edge> edgeMaker = arg_0 -> VertexStreamIterator.lambda$advanceToNextVertex$20((Graph)gLocal, arg_0);
        try (ByteArrayInputStream in = new ByteArrayInputStream(this.output.toByteArray());){
            Vertex vertex = KRYO_READER.readVertex((InputStream)in, Direction.BOTH, vertexMaker, edgeMaker);
            return vertex;
        }
    }

    private static /* synthetic */ Edge lambda$advanceToNextVertex$20(Graph graph, DetachedEdge detachedEdge) {
        return DetachedEdge.addTo((Graph)graph, (DetachedEdge)detachedEdge);
    }

    private static /* synthetic */ Vertex lambda$advanceToNextVertex$19(Graph graph, DetachedVertex detachedVertex) {
        return DetachedVertex.addTo((Graph)graph, (DetachedVertex)detachedVertex);
    }
}

