/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.hadoop.structure.io.script;

import com.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import com.tinkerpop.gremlin.process.computer.util.ScriptEngineCache;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import javax.script.ScriptEngine;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class ScriptRecordWriter
extends RecordWriter<NullWritable, VertexWritable> {
    protected static final String SCRIPT_FILE = "gremlin.hadoop.scriptOutputFormat.script";
    protected static final String SCRIPT_ENGINE = "gremlin.hadoop.scriptOutputFormat.scriptEngine";
    private static final String VERTEX = "vertex";
    private static final String WRITE_CALL = "stringify(vertex)";
    private static final String UTF8 = "UTF-8";
    private static final byte[] NEWLINE;
    private final DataOutputStream out;
    private final ScriptEngine engine;

    public ScriptRecordWriter(DataOutputStream out, TaskAttemptContext context) throws IOException {
        this.out = out;
        Configuration configuration = context.getConfiguration();
        this.engine = ScriptEngineCache.get((String)configuration.get(SCRIPT_ENGINE, "gremlin-groovy"));
        FileSystem fs = FileSystem.get((Configuration)configuration);
        try {
            this.engine.eval(new InputStreamReader((InputStream)fs.open(new Path(configuration.get(SCRIPT_FILE)))));
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public void write(NullWritable key, VertexWritable vertex) throws IOException {
        if (null != vertex) {
            try {
                this.engine.put(VERTEX, vertex.get());
                String line = (String)this.engine.eval(WRITE_CALL);
                if (line != null) {
                    this.out.write(line.getBytes(UTF8));
                    this.out.write(NEWLINE);
                }
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    public synchronized void close(TaskAttemptContext context) throws IOException {
        this.out.close();
    }

    static {
        try {
            NEWLINE = "\n".getBytes(UTF8);
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalArgumentException("Can not find UTF-8 encoding");
        }
    }
}

