/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.tinkergraph.process.computer;

import com.tinkerpop.gremlin.process.computer.GraphComputer;
import com.tinkerpop.gremlin.structure.Element;
import com.tinkerpop.gremlin.structure.Property;
import com.tinkerpop.gremlin.structure.Vertex;
import com.tinkerpop.gremlin.structure.util.ElementHelper;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerElement;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerHelper;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerProperty;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerVertex;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerVertexProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TinkerGraphView {
    protected final Set<String> computeKeys;
    protected final GraphComputer.Isolation isolation;
    private Map<Element, Map<String, List<Property>>> computeProperties;

    public TinkerGraphView(GraphComputer.Isolation isolation, Set<String> computeKeys) {
        this.isolation = isolation;
        this.computeKeys = computeKeys;
        this.computeProperties = new ConcurrentHashMap<Element, Map<String, List<Property>>>();
    }

    public <V> Property<V> setProperty(final TinkerElement element, final String key, V value) {
        ElementHelper.validateProperty((String)key, value);
        if (this.isComputeKey(key)) {
            if (element instanceof Vertex) {
                TinkerVertexProperty property = new TinkerVertexProperty<V>((TinkerVertex)element, key, value, new Object[0]){

                    @Override
                    public void remove() {
                        TinkerGraphView.this.removeProperty(element, key, (Property)this);
                    }
                };
                this.setValue(element, key, (Property)property);
                return property;
            }
            TinkerProperty property = new TinkerProperty<V>(element, key, value){

                @Override
                public void remove() {
                    TinkerGraphView.this.removeProperty((TinkerElement)this.element, this.key, this);
                }
            };
            this.setValue(element, key, property);
            return property;
        }
        throw GraphComputer.Exceptions.providedKeyIsNotAnElementComputeKey((String)key);
    }

    public List<Property> getProperty(TinkerElement element, String key) {
        return this.isComputeKey(key) ? this.getValue(element, key) : TinkerHelper.getProperties(element).getOrDefault(key, Collections.emptyList());
    }

    public List<Property> getProperties(TinkerElement element) {
        Stream a = TinkerHelper.getProperties(element).values().stream().flatMap(list -> list.stream());
        Stream b = this.computeProperties.containsKey(element) ? this.computeProperties.get(element).values().stream().flatMap(list -> list.stream()) : Stream.empty();
        return Stream.concat(a, b).collect(Collectors.toList());
    }

    public void removeProperty(TinkerElement element, String key, Property property) {
        if (this.isComputeKey(key)) {
            if (element instanceof Vertex) {
                this.removeValue(element, key, property);
            } else {
                this.removeValue(element, key);
            }
        } else {
            throw GraphComputer.Exceptions.providedKeyIsNotAnElementComputeKey((String)key);
        }
    }

    private void setValue(Element element, String key, Property property) {
        Map elementProperties = this.computeProperties.computeIfAbsent(element, k -> new ConcurrentHashMap());
        elementProperties.compute(key, (k, v) -> {
            if (element instanceof Vertex) {
                if (null == v) {
                    v = Collections.synchronizedList(new ArrayList());
                }
                v.add(property);
            } else {
                v = Arrays.asList(property);
            }
            return v;
        });
    }

    private void removeValue(Element element, String key) {
        this.computeProperties.computeIfPresent(element, (k, v) -> {
            v.remove(key);
            return v;
        });
    }

    private void removeValue(Element element, String key, Property property) {
        this.computeProperties.computeIfPresent(element, (k, v) -> {
            v.computeIfPresent(key, (k1, v1) -> {
                v1.remove(property);
                return v1;
            });
            return v;
        });
    }

    private List<Property> getValue(Element element, String key) {
        return this.computeProperties.getOrDefault(element, Collections.emptyMap()).getOrDefault(key, Collections.emptyList());
    }

    public boolean isComputeKey(String key) {
        return this.computeKeys.contains(key);
    }
}

