/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.tinkergraph.process.computer;

import com.tinkerpop.gremlin.process.computer.KeyValue;
import com.tinkerpop.gremlin.process.computer.MapReduce;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class TinkerMapEmitter<K, V>
implements MapReduce.MapEmitter<K, V> {
    public Map<K, Queue<V>> reduceMap;
    public Queue<KeyValue<K, V>> mapQueue;
    private final boolean doReduce;

    public TinkerMapEmitter(boolean doReduce) {
        this.doReduce = doReduce;
        if (this.doReduce) {
            this.reduceMap = new ConcurrentHashMap<K, Queue<V>>();
        } else {
            this.mapQueue = new ConcurrentLinkedQueue<KeyValue<K, V>>();
        }
    }

    public void emit(K key, V value) {
        if (this.doReduce) {
            this.reduceMap.computeIfAbsent(key, k -> new ConcurrentLinkedQueue()).add(value);
        } else {
            this.mapQueue.add(new KeyValue(key, value));
        }
    }

    protected void complete(MapReduce<K, V, ?, ?, ?> mapReduce) {
        if (!this.doReduce && mapReduce.getMapKeySort().isPresent()) {
            Comparator comparator = (Comparator)mapReduce.getMapKeySort().get();
            ArrayList<KeyValue<K, V>> list = new ArrayList<KeyValue<K, V>>(this.mapQueue);
            Collections.sort(list, Comparator.comparing(KeyValue::getKey, comparator));
            this.mapQueue.clear();
            this.mapQueue.addAll(list);
        } else if (mapReduce.getMapKeySort().isPresent()) {
            Comparator comparator = (Comparator)mapReduce.getMapKeySort().get();
            ArrayList<Map.Entry<K, Queue<V>>> list = new ArrayList<Map.Entry<K, Queue<V>>>();
            list.addAll(this.reduceMap.entrySet());
            Collections.sort(list, Comparator.comparing(Map.Entry::getKey, comparator));
            this.reduceMap = new LinkedHashMap<K, Queue<V>>();
            list.forEach(entry -> this.reduceMap.put(entry.getKey(), entry.getValue()));
        }
    }
}

