/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.tinkergraph.process.computer;

import com.tinkerpop.gremlin.process.Step;
import com.tinkerpop.gremlin.process.Traversal;
import com.tinkerpop.gremlin.process.computer.MessageCombiner;
import com.tinkerpop.gremlin.process.computer.MessageScope;
import com.tinkerpop.gremlin.process.computer.Messenger;
import com.tinkerpop.gremlin.process.graph.step.map.VertexStep;
import com.tinkerpop.gremlin.process.graph.step.sideEffect.StartStep;
import com.tinkerpop.gremlin.process.util.TraversalHelper;
import com.tinkerpop.gremlin.structure.Direction;
import com.tinkerpop.gremlin.structure.Edge;
import com.tinkerpop.gremlin.structure.Vertex;
import com.tinkerpop.gremlin.tinkergraph.process.computer.TinkerMessageBoard;
import com.tinkerpop.gremlin.util.StreamFactory;
import java.util.Iterator;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Stream;

public class TinkerMessenger<M>
implements Messenger<M> {
    private final Vertex vertex;
    private final TinkerMessageBoard<M> messageBoard;
    private final MessageCombiner<M> combiner;

    public TinkerMessenger(Vertex vertex, TinkerMessageBoard<M> messageBoard, Optional<MessageCombiner<M>> combiner) {
        this.vertex = vertex;
        this.messageBoard = messageBoard;
        this.combiner = combiner.isPresent() ? combiner.get() : null;
    }

    public Iterable<M> receiveMessages(MessageScope messageScope) {
        if (messageScope instanceof MessageScope.Local) {
            MessageScope.Local localMessageScope = (MessageScope.Local)messageScope;
            Object incidentTraversal = TinkerMessenger.setVertexStart((Traversal.Admin<Vertex, Edge>)((Traversal)localMessageScope.getIncidentTraversal().get()).asAdmin(), this.vertex);
            Direction direction = TinkerMessenger.getDirection(incidentTraversal);
            Edge[] edge = new Edge[1];
            return StreamFactory.iterable(StreamFactory.stream((Iterator)incidentTraversal.asAdmin().reverse()).map(e -> {
                edgeArray[0] = e;
                return this.messageBoard.receiveMessages.get(edgeArray[0].iterators().vertexIterator(direction).next());
            }).filter(q -> null != q).flatMap(q -> q.stream()).map(message -> localMessageScope.getEdgeFunction().apply(message, edge[0])));
        }
        return StreamFactory.iterable(Stream.of(this.vertex).map(this.messageBoard.receiveMessages::get).filter(q -> null != q).flatMap(q -> q.stream()));
    }

    public void sendMessage(MessageScope messageScope, M message) {
        if (messageScope instanceof MessageScope.Local) {
            this.addMessage(this.vertex, message);
        } else {
            ((MessageScope.Global)messageScope).vertices().forEach(v -> this.addMessage((Vertex)v, message));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addMessage(Vertex vertex, M message) {
        Queue queue;
        Queue queue2 = queue = this.messageBoard.sendMessages.computeIfAbsent(vertex, v -> new ConcurrentLinkedQueue());
        synchronized (queue2) {
            queue.add(null != this.combiner && !queue.isEmpty() ? this.combiner.combine(queue.remove(), message) : message);
        }
    }

    private static <T extends Traversal.Admin<Vertex, Edge>> T setVertexStart(Traversal.Admin<Vertex, Edge> incidentTraversal, Vertex vertex) {
        Traversal.Admin<Vertex, Edge> traversal = incidentTraversal;
        traversal.addStep(0, (Step)new StartStep(traversal, (Object)vertex));
        return (T)traversal;
    }

    private static Direction getDirection(Traversal.Admin<Vertex, Edge> incidentTraversal) {
        VertexStep step = (VertexStep)TraversalHelper.getLastStepOfAssignableClass(VertexStep.class, incidentTraversal).get();
        return step.getDirection();
    }
}

