/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.tinkergraph.process.computer;

import com.tinkerpop.gremlin.process.computer.MapReduce;
import com.tinkerpop.gremlin.process.computer.VertexProgram;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;

public class TinkerWorkerPool {
    private List<MapReduce> mapReducers;
    private List<VertexProgram> vertexPrograms;
    private State state;

    public TinkerWorkerPool(int numberOfWorkers, VertexProgram vertexProgram) {
        try {
            this.state = State.VERTEX_PROGRAM;
            this.vertexPrograms = new ArrayList<VertexProgram>(numberOfWorkers);
            for (int i = 0; i < numberOfWorkers; ++i) {
                this.vertexPrograms.add(vertexProgram.clone());
            }
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public TinkerWorkerPool(int numberOfWorkers, MapReduce mapReduce) {
        try {
            this.state = State.MAP_REDUCE;
            this.mapReducers = new ArrayList<MapReduce>(numberOfWorkers);
            for (int i = 0; i < numberOfWorkers; ++i) {
                this.mapReducers.add(mapReduce.clone());
            }
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void executeVertexProgram(Consumer<VertexProgram> worker) {
        if (!this.state.equals((Object)State.VERTEX_PROGRAM)) {
            throw new IllegalStateException("The provided TinkerWorkerPool is not setup for VertexProgram: " + (Object)((Object)this.state));
        }
        CountDownLatch activeWorkers = new CountDownLatch(this.vertexPrograms.size());
        for (VertexProgram vertexProgram : this.vertexPrograms) {
            new Thread(() -> {
                worker.accept(vertexProgram);
                activeWorkers.countDown();
            }).start();
        }
        try {
            activeWorkers.await();
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void executeMapReduce(Consumer<MapReduce> worker) {
        if (!this.state.equals((Object)State.MAP_REDUCE)) {
            throw new IllegalStateException("The provided TinkerWorkerPool is not setup for MapReduce: " + (Object)((Object)this.state));
        }
        CountDownLatch activeWorkers = new CountDownLatch(this.mapReducers.size());
        for (MapReduce mapReduce : this.mapReducers) {
            new Thread(() -> {
                worker.accept(mapReduce);
                activeWorkers.countDown();
            }).start();
        }
        try {
            activeWorkers.await();
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public static enum State {
        VERTEX_PROGRAM,
        MAP_REDUCE;

    }
}

