/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.tinkergraph.process.graph.step.sideEffect;

import com.tinkerpop.gremlin.process.Step;
import com.tinkerpop.gremlin.process.graph.step.sideEffect.GraphStep;
import com.tinkerpop.gremlin.process.graph.util.HasContainer;
import com.tinkerpop.gremlin.process.util.TraversalHelper;
import com.tinkerpop.gremlin.structure.Compare;
import com.tinkerpop.gremlin.structure.Edge;
import com.tinkerpop.gremlin.structure.Element;
import com.tinkerpop.gremlin.structure.Vertex;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class TinkerGraphStep<E extends Element>
extends GraphStep<E> {
    public final List<HasContainer> hasContainers = new ArrayList<HasContainer>();

    public TinkerGraphStep(GraphStep<E> originalGraphStep) {
        super(originalGraphStep.getTraversal(), originalGraphStep.getGraph(TinkerGraph.class), originalGraphStep.getReturnClass(), originalGraphStep.getIds());
        if (originalGraphStep.getLabel().isPresent()) {
            this.setLabel((String)originalGraphStep.getLabel().get());
        }
        this.setIteratorSupplier(() -> Vertex.class.isAssignableFrom(this.returnClass) ? this.vertices() : this.edges());
    }

    private Iterator<? extends Edge> edges() {
        HasContainer indexedContainer = this.getIndexKey(Edge.class);
        if (this.ids != null && this.ids.length > 0) {
            return this.iteratorList(((TinkerGraph)this.getGraph(TinkerGraph.class)).iterators().edgeIterator(this.ids));
        }
        return null == indexedContainer ? this.iteratorList(((TinkerGraph)this.getGraph(TinkerGraph.class)).iterators().edgeIterator(new Object[0])) : TinkerHelper.queryEdgeIndex((TinkerGraph)this.getGraph(TinkerGraph.class), indexedContainer.key, indexedContainer.value).stream().filter(edge -> HasContainer.testAll((Element)edge, this.hasContainers)).collect(Collectors.toList()).iterator();
    }

    private Iterator<? extends Vertex> vertices() {
        HasContainer indexedContainer = this.getIndexKey(Vertex.class);
        if (this.ids != null && this.ids.length > 0) {
            return this.iteratorList(((TinkerGraph)this.getGraph(TinkerGraph.class)).iterators().vertexIterator(this.ids));
        }
        return null == indexedContainer ? this.iteratorList(((TinkerGraph)this.getGraph(TinkerGraph.class)).iterators().vertexIterator(new Object[0])) : TinkerHelper.queryVertexIndex((TinkerGraph)this.getGraph(TinkerGraph.class), indexedContainer.key, indexedContainer.value).stream().filter(vertex -> HasContainer.testAll((Element)vertex, this.hasContainers)).collect(Collectors.toList()).iterator();
    }

    private HasContainer getIndexKey(Class<? extends Element> indexedClass) {
        Set<String> indexedKeys = ((TinkerGraph)this.getGraph(TinkerGraph.class)).getIndexedKeys(indexedClass);
        return this.hasContainers.stream().filter(c -> indexedKeys.contains(c.key) && c.predicate.equals(Compare.eq)).findAny().orElseGet(() -> null);
    }

    public String toString() {
        if (this.hasContainers.isEmpty()) {
            return super.toString();
        }
        return 0 == this.ids.length ? TraversalHelper.makeStepString((Step)this, (Object[])new Object[]{this.returnClass.getSimpleName().toLowerCase(), this.hasContainers}) : TraversalHelper.makeStepString((Step)this, (Object[])new Object[]{this.returnClass.getSimpleName().toLowerCase(), Arrays.toString(this.ids), this.hasContainers});
    }

    private final <E extends Element> Iterator<E> iteratorList(Iterator<E> iterator) {
        ArrayList<Element> list = new ArrayList<Element>();
        while (iterator.hasNext()) {
            Element e = (Element)iterator.next();
            if (!HasContainer.testAll((Element)e, this.hasContainers)) continue;
            list.add(e);
        }
        return list.iterator();
    }
}

