/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.tinkergraph.process.graph.strategy;

import com.tinkerpop.gremlin.process.Step;
import com.tinkerpop.gremlin.process.Traversal;
import com.tinkerpop.gremlin.process.TraversalEngine;
import com.tinkerpop.gremlin.process.graph.marker.HasContainerHolder;
import com.tinkerpop.gremlin.process.graph.step.sideEffect.GraphStep;
import com.tinkerpop.gremlin.process.graph.step.sideEffect.IdentityStep;
import com.tinkerpop.gremlin.process.graph.strategy.AbstractTraversalStrategy;
import com.tinkerpop.gremlin.process.util.TraversalHelper;
import com.tinkerpop.gremlin.tinkergraph.process.graph.step.sideEffect.TinkerGraphStep;

public class TinkerGraphStepStrategy
extends AbstractTraversalStrategy {
    private static final TinkerGraphStepStrategy INSTANCE = new TinkerGraphStepStrategy();

    private TinkerGraphStepStrategy() {
    }

    public void apply(Traversal.Admin<?, ?> traversal, TraversalEngine engine) {
        if (engine.equals((Object)TraversalEngine.COMPUTER)) {
            return;
        }
        Step startStep = TraversalHelper.getStart(traversal);
        if (startStep instanceof GraphStep) {
            GraphStep originalGraphStep = (GraphStep)startStep;
            TinkerGraphStep tinkerGraphStep = new TinkerGraphStep(originalGraphStep);
            TraversalHelper.replaceStep((Step)startStep, tinkerGraphStep, traversal);
            Step currentStep = tinkerGraphStep.getNextStep();
            while (true) {
                if (currentStep instanceof HasContainerHolder) {
                    tinkerGraphStep.hasContainers.addAll(((HasContainerHolder)currentStep).getHasContainers());
                    if (currentStep.getLabel().isPresent()) {
                        IdentityStep identityStep = new IdentityStep(traversal);
                        identityStep.setLabel((String)currentStep.getLabel().get());
                        TraversalHelper.insertAfterStep((Step)identityStep, (Step)currentStep, traversal);
                    }
                    traversal.removeStep(currentStep);
                } else if (!(currentStep instanceof IdentityStep)) break;
                currentStep = currentStep.getNextStep();
            }
        }
    }

    public static TinkerGraphStepStrategy instance() {
        return INSTANCE;
    }
}

