/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.tinkergraph.structure;

import com.tinkerpop.gremlin.process.T;
import com.tinkerpop.gremlin.structure.Direction;
import com.tinkerpop.gremlin.structure.Edge;
import com.tinkerpop.gremlin.structure.Element;
import com.tinkerpop.gremlin.structure.Property;
import com.tinkerpop.gremlin.structure.Vertex;
import com.tinkerpop.gremlin.structure.util.ElementHelper;
import com.tinkerpop.gremlin.structure.util.StringFactory;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerElement;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerHelper;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerProperty;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerVertex;
import com.tinkerpop.gremlin.util.iterator.IteratorUtils;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public class TinkerEdge
extends TinkerElement
implements Edge,
Edge.Iterators {
    protected final Vertex inVertex;
    protected final Vertex outVertex;

    protected TinkerEdge(Object id, Vertex outVertex, String label, Vertex inVertex, TinkerGraph graph) {
        super(id, label, graph);
        this.outVertex = outVertex;
        this.inVertex = inVertex;
        this.graph.edgeIndex.autoUpdate(T.label.getAccessor(), this.label, null, this);
    }

    public <V> Property<V> property(String key, V value) {
        if (TinkerHelper.inComputerMode(this.graph)) {
            return this.graph.graphView.setProperty(this, key, value);
        }
        ElementHelper.validateProperty((String)key, value);
        Property oldProperty = super.property(key);
        TinkerProperty<V> newProperty = new TinkerProperty<V>(this, key, value);
        this.properties.put(key, Collections.singletonList(newProperty));
        this.graph.edgeIndex.autoUpdate(key, value, oldProperty.isPresent() ? oldProperty.value() : null, this);
        return newProperty;
    }

    public void remove() {
        Set<Edge> edges;
        if (this.removed) {
            throw Element.Exceptions.elementAlreadyRemoved(Edge.class, (Object)this.id);
        }
        TinkerVertex outVertex = (TinkerVertex)this.outVertex;
        TinkerVertex inVertex = (TinkerVertex)this.inVertex;
        if (null != outVertex && null != outVertex.outEdges && null != (edges = outVertex.outEdges.get(this.label()))) {
            edges.remove(this);
        }
        if (null != inVertex && null != inVertex.inEdges && null != (edges = inVertex.inEdges.get(this.label()))) {
            edges.remove(this);
        }
        this.graph.edgeIndex.removeElement(this);
        this.graph.edges.remove(this.id());
        this.properties.clear();
        this.removed = true;
    }

    public String toString() {
        return StringFactory.edgeString((Edge)this);
    }

    public Edge.Iterators iterators() {
        return this;
    }

    public Iterator<Vertex> vertexIterator(Direction direction) {
        switch (direction) {
            case OUT: {
                return IteratorUtils.of((Object)this.outVertex);
            }
            case IN: {
                return IteratorUtils.of((Object)this.inVertex);
            }
        }
        return IteratorUtils.of((Object)this.outVertex, (Object)this.inVertex);
    }

    public <V> Iterator<Property<V>> propertyIterator(String ... propertyKeys) {
        return super.propertyIterator(propertyKeys);
    }
}

