/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.tinkergraph.structure;

import com.tinkerpop.gremlin.structure.Element;
import com.tinkerpop.gremlin.structure.Graph;
import com.tinkerpop.gremlin.structure.Property;
import com.tinkerpop.gremlin.structure.util.ElementHelper;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class TinkerElement
implements Element,
Element.Iterators {
    protected Map<String, List<Property>> properties = new HashMap<String, List<Property>>();
    protected final Object id;
    protected final String label;
    protected final TinkerGraph graph;
    protected boolean removed = false;

    protected TinkerElement(Object id, String label, TinkerGraph graph) {
        this.graph = graph;
        this.id = id;
        this.label = label;
    }

    public int hashCode() {
        return ElementHelper.hashCode((Element)this);
    }

    public Object id() {
        return this.id;
    }

    public String label() {
        return this.label;
    }

    public Graph graph() {
        return this.graph;
    }

    public Set<String> keys() {
        return TinkerHelper.inComputerMode(this.graph) ? super.keys() : this.properties.keySet();
    }

    public <V> Property<V> property(String key) {
        if (this.removed) {
            throw Element.Exceptions.elementAlreadyRemoved(this.getClass(), (Object)this.id);
        }
        if (TinkerHelper.inComputerMode(this.graph)) {
            List<Property> list = this.graph.graphView.getProperty(this, key);
            return list.size() == 0 ? Property.empty() : list.get(0);
        }
        return this.properties.containsKey(key) ? this.properties.get(key).get(0) : Property.empty();
    }

    public boolean equals(Object object) {
        return ElementHelper.areEqual((Element)this, (Object)object);
    }

    public <V> Iterator<? extends Property<V>> propertyIterator(String ... propertyKeys) {
        return TinkerHelper.inComputerMode(this.graph) ? this.graph.graphView.getProperties(this).stream().filter(p -> ElementHelper.keyExists((String)p.key(), (String[])propertyKeys)).iterator() : this.properties.entrySet().stream().filter(entry -> ElementHelper.keyExists((String)((String)entry.getKey()), (String[])propertyKeys)).flatMap(entry -> ((List)entry.getValue()).stream()).collect(Collectors.toList()).iterator();
    }
}

