/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.tinkergraph.structure;

import com.tinkerpop.gremlin.process.Step;
import com.tinkerpop.gremlin.process.T;
import com.tinkerpop.gremlin.process.Traversal;
import com.tinkerpop.gremlin.process.graph.step.map.FlatMapStep;
import com.tinkerpop.gremlin.process.graph.step.map.MapStep;
import com.tinkerpop.gremlin.process.graph.step.sideEffect.StartStep;
import com.tinkerpop.gremlin.process.util.DefaultTraversal;
import com.tinkerpop.gremlin.structure.Graph;
import com.tinkerpop.gremlin.structure.Vertex;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;

public class TinkerFactory {
    public static TinkerGraph createClassic() {
        TinkerGraph g = TinkerGraph.open();
        TinkerFactory.generateClassic(g);
        return g;
    }

    public static void generateClassic(TinkerGraph g) {
        Vertex marko = g.addVertex(T.id, 1, "name", "marko", "age", 29);
        Vertex vadas = g.addVertex(T.id, 2, "name", "vadas", "age", 27);
        Vertex lop = g.addVertex(T.id, 3, "name", "lop", "lang", "java");
        Vertex josh = g.addVertex(T.id, 4, "name", "josh", "age", 32);
        Vertex ripple = g.addVertex(T.id, 5, "name", "ripple", "lang", "java");
        Vertex peter = g.addVertex(T.id, 6, "name", "peter", "age", 35);
        marko.addEdge("knows", vadas, new Object[]{T.id, 7, "weight", Float.valueOf(0.5f)});
        marko.addEdge("knows", josh, new Object[]{T.id, 8, "weight", Float.valueOf(1.0f)});
        marko.addEdge("created", lop, new Object[]{T.id, 9, "weight", Float.valueOf(0.4f)});
        josh.addEdge("created", ripple, new Object[]{T.id, 10, "weight", Float.valueOf(1.0f)});
        josh.addEdge("created", lop, new Object[]{T.id, 11, "weight", Float.valueOf(0.4f)});
        peter.addEdge("created", lop, new Object[]{T.id, 12, "weight", Float.valueOf(0.2f)});
    }

    public static TinkerGraph createModern() {
        TinkerGraph g = TinkerGraph.open();
        TinkerFactory.generateModern(g);
        return g;
    }

    public static void generateModern(TinkerGraph g) {
        Vertex marko = g.addVertex(T.id, 1, T.label, "person", "name", "marko", "age", 29);
        Vertex vadas = g.addVertex(T.id, 2, T.label, "person", "name", "vadas", "age", 27);
        Vertex lop = g.addVertex(T.id, 3, T.label, "software", "name", "lop", "lang", "java");
        Vertex josh = g.addVertex(T.id, 4, T.label, "person", "name", "josh", "age", 32);
        Vertex ripple = g.addVertex(T.id, 5, T.label, "software", "name", "ripple", "lang", "java");
        Vertex peter = g.addVertex(T.id, 6, T.label, "person", "name", "peter", "age", 35);
        marko.addEdge("knows", vadas, new Object[]{T.id, 7, "weight", 0.5});
        marko.addEdge("knows", josh, new Object[]{T.id, 8, "weight", 1.0});
        marko.addEdge("created", lop, new Object[]{T.id, 9, "weight", 0.4});
        josh.addEdge("created", ripple, new Object[]{T.id, 10, "weight", 1.0});
        josh.addEdge("created", lop, new Object[]{T.id, 11, "weight", 0.4});
        peter.addEdge("created", lop, new Object[]{T.id, 12, "weight", 0.2});
    }

    public static TinkerGraph createTheCrew() {
        TinkerGraph g = TinkerGraph.open();
        TinkerFactory.generateTheCrew(g);
        return g;
    }

    public static void generateTheCrew(TinkerGraph g) {
        Vertex marko = g.addVertex(T.id, 1, T.label, "person", "name", "marko");
        Vertex stephen = g.addVertex(T.id, 7, T.label, "person", "name", "stephen");
        Vertex matthias = g.addVertex(T.id, 8, T.label, "person", "name", "matthias");
        Vertex daniel = g.addVertex(T.id, 9, T.label, "person", "name", "daniel");
        Vertex gremlin = g.addVertex(T.id, 10, T.label, "software", "name", "gremlin");
        Vertex tinkergraph = g.addVertex(T.id, 11, T.label, "software", "name", "tinkergraph");
        marko.property("location", (Object)"san diego", new Object[]{"startTime", 1997, "endTime", 2001});
        marko.property("location", (Object)"santa cruz", new Object[]{"startTime", 2001, "endTime", 2004});
        marko.property("location", (Object)"brussels", new Object[]{"startTime", 2004, "endTime", 2005});
        marko.property("location", (Object)"santa fe", new Object[]{"startTime", 2005});
        stephen.property("location", (Object)"centreville", new Object[]{"startTime", 1990, "endTime", 2000});
        stephen.property("location", (Object)"dulles", new Object[]{"startTime", 2000, "endTime", 2006});
        stephen.property("location", (Object)"purcellville", new Object[]{"startTime", 2006});
        matthias.property("location", (Object)"bremen", new Object[]{"startTime", 2004, "endTime", 2007});
        matthias.property("location", (Object)"baltimore", new Object[]{"startTime", 2007, "endTime", 2011});
        matthias.property("location", (Object)"oakland", new Object[]{"startTime", 2011, "endTime", 2014});
        matthias.property("location", (Object)"seattle", new Object[]{"startTime", 2014});
        daniel.property("location", (Object)"spremberg", new Object[]{"startTime", 1982, "endTime", 2005});
        daniel.property("location", (Object)"kaiserslautern", new Object[]{"startTime", 2005, "endTime", 2009});
        daniel.property("location", (Object)"aachen", new Object[]{"startTime", 2009});
        marko.addEdge("develops", gremlin, new Object[]{T.id, 13, "since", 2009});
        marko.addEdge("develops", tinkergraph, new Object[]{T.id, 14, "since", 2010});
        marko.addEdge("uses", gremlin, new Object[]{T.id, 15, "skill", 4});
        marko.addEdge("uses", tinkergraph, new Object[]{T.id, 16, "skill", 5});
        stephen.addEdge("develops", gremlin, new Object[]{T.id, 17, "since", 2010});
        stephen.addEdge("develops", tinkergraph, new Object[]{T.id, 18, "since", 2011});
        stephen.addEdge("uses", gremlin, new Object[]{T.id, 19, "skill", 5});
        stephen.addEdge("uses", tinkergraph, new Object[]{T.id, 20, "skill", 4});
        matthias.addEdge("develops", gremlin, new Object[]{T.id, 21, "since", 2012});
        matthias.addEdge("uses", gremlin, new Object[]{T.id, 22, "skill", 3});
        matthias.addEdge("uses", tinkergraph, new Object[]{T.id, 23, "skill", 3});
        daniel.addEdge("uses", gremlin, new Object[]{T.id, 24, "skill", 5});
        daniel.addEdge("uses", tinkergraph, new Object[]{T.id, 25, "skill", 3});
        gremlin.addEdge("traverses", tinkergraph, new Object[]{T.id, 26});
        g.variables().set("creator", (Object)"marko");
        g.variables().set("lastModified", (Object)2014);
        g.variables().set("comment", (Object)"this graph was created to provide examples and test coverage for tinkerpop3 api advances");
    }

    public static interface SocialTraversal<S, E>
    extends Traversal<S, E> {
        public SocialTraversal<S, Vertex> people(String var1);

        default public SocialTraversal<S, Vertex> knows() {
            FlatMapStep flatMapStep = new FlatMapStep((Traversal)this);
            flatMapStep.setFunction(v -> ((Vertex)v.get()).out(new String[]{"knows"}));
            return (SocialTraversal)this.asAdmin().addStep((Step)flatMapStep);
        }

        default public SocialTraversal<S, Vertex> created() {
            FlatMapStep flatMapStep = new FlatMapStep((Traversal)this);
            flatMapStep.setFunction(v -> ((Vertex)v.get()).out(new String[]{"created"}));
            return (SocialTraversal)this.asAdmin().addStep((Step)flatMapStep);
        }

        default public SocialTraversal<S, String> name() {
            MapStep mapStep = new MapStep((Traversal)this);
            mapStep.setFunction(v -> (String)((Vertex)v.get()).value("name"));
            return (SocialTraversal)this.asAdmin().addStep((Step)mapStep);
        }

        public static <S> SocialTraversal<S, S> of(Graph graph) {
            return new DefaultSocialTraversal(graph);
        }

        public static class DefaultSocialTraversal<S, E>
        extends DefaultTraversal<S, E>
        implements SocialTraversal<S, E> {
            private final Graph graph;

            public DefaultSocialTraversal(Graph graph) {
                super(Graph.class);
                this.graph = graph;
            }

            @Override
            public SocialTraversal<S, Vertex> people(String name) {
                return (SocialTraversal)this.asAdmin().addStep((Step)new StartStep((Traversal)this, (Object)this.graph.V(new Object[0]).has("name", (Object)name)));
            }
        }
    }
}

