/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.tinkergraph.structure;

import com.tinkerpop.gremlin.process.TraversalStrategies;
import com.tinkerpop.gremlin.process.TraversalStrategy;
import com.tinkerpop.gremlin.process.computer.GraphComputer;
import com.tinkerpop.gremlin.process.computer.util.GraphComputerHelper;
import com.tinkerpop.gremlin.structure.Edge;
import com.tinkerpop.gremlin.structure.Element;
import com.tinkerpop.gremlin.structure.Graph;
import com.tinkerpop.gremlin.structure.Transaction;
import com.tinkerpop.gremlin.structure.Vertex;
import com.tinkerpop.gremlin.structure.util.ElementHelper;
import com.tinkerpop.gremlin.structure.util.StringFactory;
import com.tinkerpop.gremlin.tinkergraph.process.computer.TinkerGraphComputer;
import com.tinkerpop.gremlin.tinkergraph.process.computer.TinkerGraphView;
import com.tinkerpop.gremlin.tinkergraph.process.graph.strategy.TinkerElementStepStrategy;
import com.tinkerpop.gremlin.tinkergraph.process.graph.strategy.TinkerGraphStepStrategy;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerEdge;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerGraphVariables;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerHelper;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerIndex;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerVertex;
import com.tinkerpop.gremlin.util.iterator.IteratorUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;

@Graph.OptIns(value={@Graph.OptIn(value="com.tinkerpop.gremlin.structure.StructureStandardSuite"), @Graph.OptIn(value="com.tinkerpop.gremlin.structure.StructurePerformanceSuite"), @Graph.OptIn(value="com.tinkerpop.gremlin.process.ProcessStandardSuite"), @Graph.OptIn(value="com.tinkerpop.gremlin.process.ProcessComputerSuite"), @Graph.OptIn(value="com.tinkerpop.gremlin.process.GroovyProcessStandardSuite"), @Graph.OptIn(value="com.tinkerpop.gremlin.process.GroovyProcessComputerSuite"), @Graph.OptIn(value="com.tinkerpop.gremlin.groovy.GroovyEnvironmentSuite"), @Graph.OptIn(value="com.tinkerpop.gremlin.groovy.GroovyEnvironmentIntegrateSuite")})
public class TinkerGraph
implements Graph,
Graph.Iterators {
    private static final Configuration EMPTY_CONFIGURATION;
    protected Long currentId = -1L;
    protected Map<Object, Vertex> vertices = new HashMap<Object, Vertex>();
    protected Map<Object, Edge> edges = new HashMap<Object, Edge>();
    protected TinkerGraphVariables variables = new TinkerGraphVariables();
    protected TinkerGraphView graphView = null;
    protected TinkerIndex<TinkerVertex> vertexIndex = new TinkerIndex<TinkerVertex>(this, TinkerVertex.class);
    protected TinkerIndex<TinkerEdge> edgeIndex = new TinkerIndex<TinkerEdge>(this, TinkerEdge.class);

    private TinkerGraph() {
    }

    public static TinkerGraph open() {
        return TinkerGraph.open(null);
    }

    public static TinkerGraph open(Configuration configuration) {
        return new TinkerGraph();
    }

    public Vertex addVertex(Object ... keyValues) {
        ElementHelper.legalPropertyKeyValueArray((Object[])keyValues);
        Long idValue = ElementHelper.getIdValue((Object[])keyValues).orElse(null);
        String label = ElementHelper.getLabelValue((Object[])keyValues).orElse("vertex");
        if (null != idValue) {
            if (this.vertices.containsKey(idValue)) {
                throw Graph.Exceptions.vertexWithIdAlreadyExists((Object)idValue);
            }
        } else {
            idValue = TinkerHelper.getNextId(this);
        }
        TinkerVertex vertex = new TinkerVertex(idValue, label, this);
        this.vertices.put(vertex.id(), vertex);
        ElementHelper.attachProperties((Element)vertex, (Object[])keyValues);
        return vertex;
    }

    public GraphComputer compute(Class ... graphComputerClass) {
        GraphComputerHelper.validateComputeArguments((Class[])graphComputerClass);
        if (graphComputerClass.length == 0 || graphComputerClass[0].equals(TinkerGraphComputer.class)) {
            return new TinkerGraphComputer(this);
        }
        throw Graph.Exceptions.graphDoesNotSupportProvidedGraphComputer((Class)graphComputerClass[0]);
    }

    public Graph.Variables variables() {
        return this.variables;
    }

    public String toString() {
        return StringFactory.graphString((Graph)this, (String)("vertices:" + this.vertices.size() + " edges:" + this.edges.size()));
    }

    public void clear() {
        this.vertices.clear();
        this.edges.clear();
        this.variables = new TinkerGraphVariables();
        this.currentId = 0L;
        this.vertexIndex = new TinkerIndex<TinkerVertex>(this, TinkerVertex.class);
        this.edgeIndex = new TinkerIndex<TinkerEdge>(this, TinkerEdge.class);
    }

    public void close() {
    }

    public Transaction tx() {
        throw Graph.Exceptions.transactionsNotSupported();
    }

    public Configuration configuration() {
        return EMPTY_CONFIGURATION;
    }

    public Graph.Iterators iterators() {
        return this;
    }

    public Iterator<Vertex> vertexIterator(Object ... vertexIds) {
        if (0 == vertexIds.length) {
            return this.vertices.values().iterator();
        }
        if (1 == vertexIds.length) {
            Vertex vertex = this.vertices.get(vertexIds[0]);
            return null == vertex ? Collections.emptyIterator() : IteratorUtils.of((Object)vertex);
        }
        return Stream.of(vertexIds).filter(this.vertices::containsKey).map(this.vertices::get).iterator();
    }

    public Iterator<Edge> edgeIterator(Object ... edgeIds) {
        if (0 == edgeIds.length) {
            return this.edges.values().iterator();
        }
        if (1 == edgeIds.length) {
            Edge edge = this.edges.get(edgeIds[0]);
            return null == edge ? Collections.emptyIterator() : IteratorUtils.of((Object)edge);
        }
        return Stream.of(edgeIds).filter(this.edges::containsKey).map(this.edges::get).iterator();
    }

    public Graph.Features features() {
        return new TinkerGraphFeatures();
    }

    public <E extends Element> void createIndex(String key, Class<E> elementClass) {
        if (Vertex.class.isAssignableFrom(elementClass)) {
            this.vertexIndex.createKeyIndex(key);
        } else if (Edge.class.isAssignableFrom(elementClass)) {
            this.edgeIndex.createKeyIndex(key);
        } else {
            throw new IllegalArgumentException("Class is not indexable: " + elementClass);
        }
    }

    public <E extends Element> void dropIndex(String key, Class<E> elementClass) {
        if (Vertex.class.isAssignableFrom(elementClass)) {
            this.vertexIndex.dropKeyIndex(key);
        } else if (Edge.class.isAssignableFrom(elementClass)) {
            this.edgeIndex.dropKeyIndex(key);
        } else {
            throw new IllegalArgumentException("Class is not indexable: " + elementClass);
        }
    }

    public <E extends Element> Set<String> getIndexedKeys(Class<E> elementClass) {
        if (Vertex.class.isAssignableFrom(elementClass)) {
            return this.vertexIndex.getIndexedKeys();
        }
        if (Edge.class.isAssignableFrom(elementClass)) {
            return this.edgeIndex.getIndexedKeys();
        }
        throw new IllegalArgumentException("Class is not indexable: " + elementClass);
    }

    public void dropGraphView() {
        this.graphView = null;
    }

    static {
        try {
            TraversalStrategies.GlobalCache.registerStrategies(TinkerGraph.class, (TraversalStrategies)TraversalStrategies.GlobalCache.getStrategies(Graph.class).clone().addStrategies(new TraversalStrategy[]{TinkerGraphStepStrategy.instance()}));
            TraversalStrategies.GlobalCache.registerStrategies(TinkerVertex.class, (TraversalStrategies)TraversalStrategies.GlobalCache.getStrategies(Vertex.class).clone().addStrategies(new TraversalStrategy[]{TinkerElementStepStrategy.instance()}));
            TraversalStrategies.GlobalCache.registerStrategies(TinkerEdge.class, (TraversalStrategies)TraversalStrategies.GlobalCache.getStrategies(Edge.class).clone().addStrategies(new TraversalStrategy[]{TinkerElementStepStrategy.instance()}));
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        EMPTY_CONFIGURATION = new BaseConfiguration(){
            {
                this.setProperty("gremlin.graph", TinkerGraph.class.getName());
            }
        };
    }

    public static class TinkerGraphGraphFeatures
    implements Graph.Features.GraphFeatures {
        public boolean supportsTransactions() {
            return false;
        }

        public boolean supportsPersistence() {
            return false;
        }

        public boolean supportsThreadedTransactions() {
            return false;
        }
    }

    public static class TinkerGraphEdgeFeatures
    implements Graph.Features.EdgeFeatures {
        public boolean supportsCustomIds() {
            return false;
        }
    }

    public static class TinkerGraphVertexFeatures
    implements Graph.Features.VertexFeatures {
        public boolean supportsCustomIds() {
            return false;
        }
    }

    public static class TinkerGraphFeatures
    implements Graph.Features {
        public Graph.Features.GraphFeatures graph() {
            return new TinkerGraphGraphFeatures();
        }

        public Graph.Features.EdgeFeatures edge() {
            return new TinkerGraphEdgeFeatures();
        }

        public Graph.Features.VertexFeatures vertex() {
            return new TinkerGraphVertexFeatures();
        }

        public String toString() {
            return StringFactory.featureString((Graph.Features)this);
        }
    }
}

