/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.tinkergraph.structure;

import com.tinkerpop.gremlin.process.computer.GraphComputer;
import com.tinkerpop.gremlin.structure.Direction;
import com.tinkerpop.gremlin.structure.Edge;
import com.tinkerpop.gremlin.structure.Element;
import com.tinkerpop.gremlin.structure.Graph;
import com.tinkerpop.gremlin.structure.Property;
import com.tinkerpop.gremlin.structure.util.ElementHelper;
import com.tinkerpop.gremlin.tinkergraph.process.computer.TinkerGraphView;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerEdge;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerElement;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerVertex;
import com.tinkerpop.gremlin.util.iterator.IteratorUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TinkerHelper {
    protected static final synchronized long getNextId(TinkerGraph graph) {
        return Stream.generate(() -> {
            tinkerGraph.currentId = tinkerGraph.currentId + 1L;
            return tinkerGraph.currentId;
        }).filter(id -> !tinkerGraph.vertices.containsKey(id) && !tinkerGraph.edges.containsKey(id)).findAny().get();
    }

    protected static Edge addEdge(TinkerGraph graph, TinkerVertex outVertex, TinkerVertex inVertex, String label, Object ... keyValues) {
        ElementHelper.validateLabel((String)label);
        ElementHelper.legalPropertyKeyValueArray((Object[])keyValues);
        Long idValue = ElementHelper.getIdValue((Object[])keyValues).orElse(null);
        if (null != idValue) {
            if (graph.edges.containsKey(idValue)) {
                throw Graph.Exceptions.edgeWithIdAlreadyExists((Object)idValue);
            }
        } else {
            idValue = TinkerHelper.getNextId(graph);
        }
        TinkerEdge edge = new TinkerEdge(idValue, outVertex, label, inVertex, graph);
        ElementHelper.attachProperties((Element)edge, (Object[])keyValues);
        graph.edges.put(edge.id(), edge);
        TinkerHelper.addOutEdge(outVertex, label, edge);
        TinkerHelper.addInEdge(inVertex, label, edge);
        return edge;
    }

    protected static void addOutEdge(TinkerVertex vertex, String label, Edge edge) {
        Set<Edge> edges = vertex.outEdges.get(label);
        if (null == edges) {
            edges = new HashSet<Edge>();
            vertex.outEdges.put(label, edges);
        }
        edges.add(edge);
    }

    protected static void addInEdge(TinkerVertex vertex, String label, Edge edge) {
        Set<Edge> edges = vertex.inEdges.get(label);
        if (null == edges) {
            edges = new HashSet<Edge>();
            vertex.inEdges.put(label, edges);
        }
        edges.add(edge);
    }

    public static void dropView(TinkerGraph graph) {
        graph.graphView = null;
    }

    public static List<TinkerVertex> queryVertexIndex(TinkerGraph graph, String key, Object value) {
        return graph.vertexIndex.get(key, value);
    }

    public static List<TinkerEdge> queryEdgeIndex(TinkerGraph graph, String key, Object value) {
        return graph.edgeIndex.get(key, value);
    }

    public static boolean inComputerMode(TinkerGraph graph) {
        return null != graph.graphView;
    }

    public static TinkerGraphView createGraphView(TinkerGraph graph, GraphComputer.Isolation isolation, Set<String> computeKeys) {
        graph.graphView = new TinkerGraphView(isolation, computeKeys);
        return graph.graphView;
    }

    public static Map<String, List<Property>> getProperties(TinkerElement element) {
        return element.properties;
    }

    public static final Iterator<TinkerEdge> getEdges(TinkerVertex vertex, Direction direction, String ... edgeLabels) {
        Stream edgeStream = null;
        if (direction.equals((Object)Direction.OUT) || direction.equals((Object)Direction.BOTH)) {
            edgeStream = (edgeLabels.length == 0 ? vertex.outEdges.keySet().stream() : Stream.of(edgeLabels)).filter(label -> !Graph.Hidden.isHidden((String)label)).map(vertex.outEdges::get).filter(edges -> null != edges).flatMap(list -> list.stream());
        }
        if (direction.equals((Object)Direction.IN) || direction.equals((Object)Direction.BOTH)) {
            edgeStream = Stream.concat(null == edgeStream ? Stream.empty() : edgeStream, (edgeLabels.length == 0 ? vertex.inEdges.keySet().stream() : Stream.of(edgeLabels)).filter(label -> !Graph.Hidden.isHidden((String)label)).map(vertex.inEdges::get).filter(edges -> null != edges).flatMap(list -> list.stream()));
        }
        return edgeStream.collect(Collectors.toList()).iterator();
    }

    public static final Iterator<TinkerVertex> getVertices(TinkerVertex vertex, Direction direction, String ... edgeLabels) {
        if (direction != Direction.BOTH) {
            return IteratorUtils.map(TinkerHelper.getEdges(vertex, direction, edgeLabels), direction.equals((Object)Direction.IN) ? edge -> (TinkerVertex)edge.outVertex : edge -> (TinkerVertex)edge.inVertex);
        }
        return IteratorUtils.concat((Iterator[])new Iterator[]{IteratorUtils.map(TinkerHelper.getEdges(vertex, Direction.OUT, edgeLabels), edge -> (TinkerVertex)edge.inVertex), IteratorUtils.map(TinkerHelper.getEdges(vertex, Direction.IN, edgeLabels), edge -> (TinkerVertex)edge.outVertex)});
    }
}

