/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.tinkergraph.structure;

import com.tinkerpop.gremlin.structure.Edge;
import com.tinkerpop.gremlin.structure.Element;
import com.tinkerpop.gremlin.structure.Property;
import com.tinkerpop.gremlin.structure.util.ElementHelper;
import com.tinkerpop.gremlin.structure.util.StringFactory;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerEdge;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerElement;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;

public class TinkerProperty<V>
implements Property<V> {
    protected final Element element;
    protected final String key;
    protected V value;
    protected final TinkerGraph graph;

    public TinkerProperty(Element element, String key, V value) {
        this.element = element;
        this.key = key;
        this.value = value;
        this.graph = ((TinkerElement)this.element).graph;
    }

    public Element element() {
        return this.element;
    }

    public String key() {
        return this.key;
    }

    public V value() {
        return this.value;
    }

    public boolean isPresent() {
        return null != this.value;
    }

    public String toString() {
        return StringFactory.propertyString((Property)this);
    }

    public boolean equals(Object object) {
        return ElementHelper.areEqual((Property)this, (Object)object);
    }

    public int hashCode() {
        return ElementHelper.hashCode((Property)this);
    }

    public void remove() {
        ((TinkerElement)this.element).properties.remove(this.key);
        if (this.element instanceof Edge) {
            this.graph.edgeIndex.remove(this.key, this.value, (TinkerEdge)this.element);
        }
    }
}

