/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.tinkergraph.structure;

import com.tinkerpop.gremlin.structure.Direction;
import com.tinkerpop.gremlin.structure.Edge;
import com.tinkerpop.gremlin.structure.Element;
import com.tinkerpop.gremlin.structure.Graph;
import com.tinkerpop.gremlin.structure.Property;
import com.tinkerpop.gremlin.structure.Vertex;
import com.tinkerpop.gremlin.structure.VertexProperty;
import com.tinkerpop.gremlin.structure.util.ElementHelper;
import com.tinkerpop.gremlin.structure.util.StringFactory;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerEdge;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerElement;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerHelper;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerVertexProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class TinkerVertex
extends TinkerElement
implements Vertex,
Vertex.Iterators {
    protected Map<String, Set<Edge>> outEdges = new HashMap<String, Set<Edge>>();
    protected Map<String, Set<Edge>> inEdges = new HashMap<String, Set<Edge>>();
    private static final Object[] EMPTY_ARGS = new Object[0];

    protected TinkerVertex(Object id, String label, TinkerGraph graph) {
        super(id, label, graph);
    }

    public <V> VertexProperty<V> property(String key) {
        if (this.removed) {
            throw Element.Exceptions.elementAlreadyRemoved(Vertex.class, (Object)this.id);
        }
        if (TinkerHelper.inComputerMode(this.graph)) {
            List<Property> list = this.graph.graphView.getProperty(this, key);
            if (list.size() == 0) {
                return VertexProperty.empty();
            }
            if (list.size() == 1) {
                return (VertexProperty)list.get(0);
            }
            throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey((String)key);
        }
        if (this.properties.containsKey(key)) {
            List list = (List)this.properties.get(key);
            if (list.size() > 1) {
                throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey((String)key);
            }
            return (VertexProperty)list.get(0);
        }
        return VertexProperty.empty();
    }

    public <V> VertexProperty<V> property(String key, V value) {
        return this.property(key, value, EMPTY_ARGS);
    }

    public <V> VertexProperty<V> property(String key, V value, Object ... keyValues) {
        if (this.removed) {
            throw Element.Exceptions.elementAlreadyRemoved(Vertex.class, (Object)this.id);
        }
        ElementHelper.legalPropertyKeyValueArray((Object[])keyValues);
        Optional optionalId = ElementHelper.getIdValue((Object[])keyValues);
        if (TinkerHelper.inComputerMode(this.graph)) {
            VertexProperty vertexProperty = (VertexProperty)this.graph.graphView.setProperty(this, key, value);
            ElementHelper.attachProperties((Element)vertexProperty, (Object[])keyValues);
            return vertexProperty;
        }
        ElementHelper.validateProperty((String)key, value);
        TinkerVertexProperty<V> vertexProperty = optionalId.isPresent() ? new TinkerVertexProperty<V>(optionalId.get(), this, key, value, new Object[0]) : new TinkerVertexProperty<V>(this, key, value, new Object[0]);
        List list = this.properties.getOrDefault(key, new ArrayList());
        list.add(vertexProperty);
        this.properties.put(key, list);
        this.graph.vertexIndex.autoUpdate(key, value, null, this);
        ElementHelper.attachProperties(vertexProperty, (Object[])keyValues);
        return vertexProperty;
    }

    public Edge addEdge(String label, Vertex vertex, Object ... keyValues) {
        if (null == vertex) {
            throw Graph.Exceptions.argumentCanNotBeNull((String)"vertex");
        }
        if (this.removed) {
            throw Element.Exceptions.elementAlreadyRemoved(Vertex.class, (Object)this.id);
        }
        return TinkerHelper.addEdge(this.graph, this, (TinkerVertex)vertex, label, keyValues);
    }

    public void remove() {
        if (this.removed) {
            throw Element.Exceptions.elementAlreadyRemoved(Vertex.class, (Object)this.id);
        }
        ArrayList edges = new ArrayList();
        this.iterators().edgeIterator(Direction.BOTH, new String[0]).forEachRemaining(edges::add);
        edges.stream().filter(edge -> !((TinkerEdge)edge).removed).forEach(Element::remove);
        this.properties.clear();
        this.graph.vertexIndex.removeElement(this);
        this.graph.vertices.remove(this.id);
        this.removed = true;
    }

    public String toString() {
        return StringFactory.vertexString((Vertex)this);
    }

    public Vertex.Iterators iterators() {
        return this;
    }

    public <V> Iterator<VertexProperty<V>> propertyIterator(String ... propertyKeys) {
        return super.propertyIterator(propertyKeys);
    }

    public Iterator<Edge> edgeIterator(Direction direction, String ... edgeLabels) {
        return TinkerHelper.getEdges(this, direction, edgeLabels);
    }

    public Iterator<Vertex> vertexIterator(Direction direction, String ... edgeLabels) {
        return TinkerHelper.getVertices(this, direction, edgeLabels);
    }
}

