/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.tinkergraph.structure;

import com.tinkerpop.gremlin.structure.Element;
import com.tinkerpop.gremlin.structure.Property;
import com.tinkerpop.gremlin.structure.Vertex;
import com.tinkerpop.gremlin.structure.VertexProperty;
import com.tinkerpop.gremlin.structure.util.ElementHelper;
import com.tinkerpop.gremlin.structure.util.StringFactory;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerElement;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerHelper;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerProperty;
import com.tinkerpop.gremlin.tinkergraph.structure.TinkerVertex;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class TinkerVertexProperty<V>
extends TinkerElement
implements VertexProperty<V>,
VertexProperty.Iterators {
    private final TinkerVertex vertex;
    private final String key;
    private final V value;

    public TinkerVertexProperty(TinkerVertex vertex, String key, V value, Object ... propertyKeyValues) {
        super(TinkerHelper.getNextId(vertex.graph), key, vertex.graph);
        this.vertex = vertex;
        this.key = key;
        this.value = value;
        ElementHelper.legalPropertyKeyValueArray((Object[])propertyKeyValues);
        ElementHelper.attachProperties((Element)this, (Object[])propertyKeyValues);
    }

    public TinkerVertexProperty(Object id, TinkerVertex vertex, String key, V value, Object ... propertyKeyValues) {
        super(id, key, vertex.graph);
        this.vertex = vertex;
        this.key = key;
        this.value = value;
        ElementHelper.legalPropertyKeyValueArray((Object[])propertyKeyValues);
        ElementHelper.attachProperties((Element)this, (Object[])propertyKeyValues);
    }

    public String key() {
        return this.key;
    }

    public V value() {
        return this.value;
    }

    public boolean isPresent() {
        return true;
    }

    public String toString() {
        return StringFactory.propertyString((Property)this);
    }

    @Override
    public Object id() {
        return this.id;
    }

    @Override
    public boolean equals(Object object) {
        return ElementHelper.areEqual((VertexProperty)this, (Object)object);
    }

    public <U> Property<U> property(String key, U value) {
        TinkerProperty<U> property = new TinkerProperty<U>(this, key, value);
        this.properties.put(key, Collections.singletonList(property));
        return property;
    }

    public Vertex element() {
        return this.vertex;
    }

    public void remove() {
        if (this.vertex.properties.containsKey(this.key)) {
            ((List)this.vertex.properties.get(this.key)).remove(this);
            if (((List)this.vertex.properties.get(this.key)).size() == 0) {
                this.vertex.properties.remove(this.key);
                this.graph.vertexIndex.remove(this.key, this.value, this.vertex);
            }
            AtomicBoolean delete = new AtomicBoolean(true);
            this.vertex.propertyIterator(this.key).forEachRemaining(property -> {
                if (property.value().equals(this.value)) {
                    delete.set(false);
                }
            });
            if (delete.get()) {
                this.graph.vertexIndex.remove(this.key, this.value, this.vertex);
            }
            this.properties.clear();
            this.removed = true;
        }
    }

    public VertexProperty.Iterators iterators() {
        return this;
    }

    public <U> Iterator<Property<U>> propertyIterator(String ... propertyKeys) {
        return super.propertyIterator(propertyKeys);
    }
}

