/*
 * Decompiled with CFR 0.152.
 */
package com.tisonkun.os.maven;

import com.tisonkun.os.core.DefaultFileOperations;
import com.tisonkun.os.core.DefaultSystemPropertyOperations;
import com.tisonkun.os.core.DetectionException;
import com.tisonkun.os.core.Detector;
import com.tisonkun.os.core.FileOperationProvider;
import com.tisonkun.os.core.SystemPropertyOperationProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="detect", defaultPhase=LifecyclePhase.VALIDATE, threadSafe=true)
public class DetectMojo
extends AbstractMojo {
    static final String CLASSIFIER_WITH_LIKES_PROPERTY = "os.detection.classifierWithLikes";
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(property="os.detection.classifierWithLikes", defaultValue="${os.detection.classifierWithLikes}")
    private String classifierWithLikes;
    private final Detector detector = new Detector((SystemPropertyOperationProvider)new DefaultSystemPropertyOperations(), (FileOperationProvider)new DefaultFileOperations(), message -> this.getLog().info((CharSequence)message));

    public void execute() throws MojoExecutionException {
        try {
            this.detector.detect(this.project.getProperties(), DetectMojo.getClassifierWithLikes(this.classifierWithLikes));
        }
        catch (DetectionException e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    public static List<String> getClassifierWithLikes(String propertyValue) {
        if (propertyValue == null) {
            return Collections.emptyList();
        }
        String[] parts = propertyValue.split(",");
        ArrayList<String> likes = new ArrayList<String>(parts.length);
        for (String part : parts) {
            if ((part = part.trim()).isEmpty()) continue;
            likes.add(part);
        }
        return likes;
    }
}

